/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Phase;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.StepBlock;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.archive.BlockType;
import com.xebialabs.deployit.task.archive.NodeNames;
import com.xebialabs.deployit.task.archive.TaskArchiver;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import org.joda.time.DateTime;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public abstract class TaskArchiver$class {
    /*
     * WARNING - void declaration
     */
    public static Node createTaskNode(TaskArchiver $this, Node rootNode) {
        void var3_3;
        Node taskType = JcrUtils.getOrCreateChild((Node)rootNode, (String)TaskMetadata.getMetadata($this.task(), TaskMetadata.TASK_TYPE));
        Node node2 = taskType.addNode($this.task().getId());
        node2.addMixin("deployit:task");
        return var3_3;
    }

    public static void fillTaskNode(TaskArchiver $this, Node taskNode, boolean fillBlocks) {
        BlockState block = $this.task().getBlock();
        taskNode.setProperty("$id", $this.task().getId());
        taskNode.setProperty(NodeNames.STATE, $this.task().getState().name());
        taskNode.setProperty(NodeNames.START_DATE, (Calendar)$this.task().getStartDate().toGregorianCalendar());
        taskNode.setProperty(NodeNames.COMPLETION_DATE, (Calendar)$this.task().getCompletionDate().toGregorianCalendar());
        taskNode.setProperty(NodeNames.OWNING_USER, $this.task().getOwner());
        taskNode.setProperty(NodeNames.FAILURE_COUNT, (long)$this.task().getFailureCount());
        taskNode.setProperty(NodeNames.DEPLOYMENT_TYPE, TaskMetadata.getMetadata($this.task(), TaskMetadata.TASK_TYPE));
        DateTime scheduledDate = $this.task().getScheduledDate();
        Object object = scheduledDate == null ? BoxedUnit.UNIT : taskNode.setProperty(NodeNames.SCHEDULED_DATE, (Calendar)scheduledDate.toGregorianCalendar());
        if (fillBlocks) {
            TaskArchiver$class.fillRootBlock($this, taskNode, block);
        }
    }

    public static boolean fillTaskNode$default$2(TaskArchiver $this) {
        return true;
    }

    private static void fillRootBlock(TaskArchiver $this, Node taskNode, BlockState block) {
        if (block != null) {
            TaskArchiver$class.com$xebialabs$deployit$task$archive$TaskArchiver$$fillBlockNode($this, taskNode, block);
        }
    }

    public static void com$xebialabs$deployit$task$archive$TaskArchiver$$fillBlockNode(TaskArchiver $this, Node taskNode, BlockState block) {
        BlockState blockState;
        block6: {
            block3: {
                Node blockNode;
                block5: {
                    block4: {
                        block2: {
                            blockNode = taskNode.addNode(block.getId());
                            blockNode.setProperty(NodeNames.BLOCK_DESCRIPTION, block.getDescription());
                            blockNode.setProperty(NodeNames.BLOCK_STATE, block.getState().name());
                            blockState = block;
                            if (!(blockState instanceof PhaseContainer)) break block2;
                            PhaseContainer phaseContainer = (PhaseContainer)blockState;
                            TaskArchiver$class.fillPhaseContainer($this, blockNode, phaseContainer);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(blockState instanceof Phase)) break block4;
                        Phase phase = (Phase)blockState;
                        TaskArchiver$class.fillPhase($this, blockNode, phase);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(blockState instanceof StepBlock)) break block5;
                    StepBlock stepBlock = (StepBlock)blockState;
                    TaskArchiver$class.fillStepBlock($this, blockNode, stepBlock);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(blockState instanceof CompositeBlockState)) break block6;
                CompositeBlockState compositeBlockState = (CompositeBlockState)blockState;
                TaskArchiver$class.fillCompositeBlock($this, blockNode, compositeBlockState);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)blockState);
    }

    private static void fillPhaseContainer(TaskArchiver $this, Node blockNode, PhaseContainer container) {
        blockNode.setProperty(NodeNames.BLOCK_TYPE, BlockType.PHASE_BLOCK_CONTAINER.name());
        ((WrapAsScala)package$.MODULE$.wrapAll()).iterableAsScalaIterable(container.getPhases()).foreach((Function1)new Serializable($this, blockNode){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskArchiver $outer;
            private final Node blockNode$1;

            public final void apply(Phase p) {
                TaskArchiver$class.com$xebialabs$deployit$task$archive$TaskArchiver$$fillBlockNode(this.$outer, this.blockNode$1, (BlockState)p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockNode$1 = blockNode$1;
            }
        });
    }

    private static void fillPhase(TaskArchiver $this, Node blockNode, Phase phase) {
        blockNode.setProperty(NodeNames.BLOCK_TYPE, BlockType.PHASE_BLOCK.name());
        TaskArchiver$class.com$xebialabs$deployit$task$archive$TaskArchiver$$fillBlockNode($this, blockNode, (BlockState)phase.block());
    }

    private static void fillCompositeBlock(TaskArchiver $this, Node blockNode, CompositeBlockState block) {
        blockNode.setProperty(NodeNames.BLOCK_TYPE, BlockType.COMPOSITE_BLOCK.name());
        blockNode.setProperty(NodeNames.IS_PARALLEL, block.isParallel());
        ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(block.getBlocks()).foreach((Function1)new Serializable($this, blockNode){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskArchiver $outer;
            private final Node blockNode$2;

            public final void apply(BlockState b) {
                TaskArchiver$class.com$xebialabs$deployit$task$archive$TaskArchiver$$fillBlockNode(this.$outer, this.blockNode$2, b);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockNode$2 = blockNode$2;
            }
        });
    }

    private static void fillStepBlock(TaskArchiver $this, Node blockNode, StepBlock block) {
        blockNode.setProperty(NodeNames.BLOCK_TYPE, BlockType.STEP_BLOCK.name());
        blockNode.setProperty(NodeNames.CURRENT_STEP_NR_BLOCK, 0L);
        TaskArchiver$class.fillStepNode($this, blockNode, block.getSteps());
    }

    private static void fillStepNode(TaskArchiver $this, Node taskNode, List steps) {
        IntRef nr = IntRef.create((int)1);
        ((WrapAsScala)package$.MODULE$.wrapAll()).asScalaBuffer(steps).foreach((Function1)new Serializable($this, taskNode, nr){
            public static final long serialVersionUID = 0L;
            private final Node taskNode$1;
            private final IntRef nr$1;

            public final Property apply(StepState step) {
                Node stepNode = this.taskNode$1.addNode(new StringBuilder().append((Object)"step").append((Object)BoxesRunTime.boxToInteger((int)this.nr$1.elem)).toString());
                ++this.nr$1.elem;
                stepNode.setProperty(NodeNames.DESCRIPTION, step.getDescription());
                stepNode.setProperty(NodeNames.STATE, step.getState().name());
                stepNode.setProperty(NodeNames.START_DATE, step.getStartDate() == null ? null : step.getStartDate().toGregorianCalendar());
                stepNode.setProperty(NodeNames.COMPLETION_DATE, step.getCompletionDate() == null ? null : step.getCompletionDate().toGregorianCalendar());
                stepNode.setProperty(NodeNames.FAILURE_COUNT, (long)step.getFailureCount());
                return stepNode.setProperty(NodeNames.LOG, step.getLog());
            }
            {
                this.taskNode$1 = taskNode$1;
                this.nr$1 = nr$1;
            }
        });
    }

    public static void $init$(TaskArchiver $this) {
    }
}

