package com.xebialabs.deployit.task.archive

import javax.jcr.Node

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState._
import com.xebialabs.deployit.engine.api.execution.{BlockExecutionState, BlockState}
import com.xebialabs.deployit.jcr.JcrUtils._

trait BlockReader {

  import com.xebialabs.deployit.task.archive.NodeNames._

  def read(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): BlockState

  def readFirstBlock(taskNode: Node, loadSteps: Boolean): ArchivedPhaseContainer

  protected def readBasicBlockProperties(blockNode: Node, block: ArchivedAbstractBlock, uptodateModel: Boolean) {
    val blockId = if (uptodateModel) blockNode.getName else s"0_1_${blockNode.getName}"

    block.setId(blockId)
    block.setDescription(getProperty(blockNode, BLOCK_DESCRIPTION))
    block.setState(BlockExecutionState.valueOf(getProperty(blockNode, BLOCK_STATE)))
  }

  protected def wrapInPhaseContainer(firstBlock: ArchivedAbstractBlock): ArchivedPhaseContainer = {
    val phase = new ArchivedPhase(firstBlock)

    phase.setState(STOPPED)
    phase.setDescription("phase1")
    val container = new ArchivedPhaseContainer(java.util.Arrays.asList(phase))
    container.setState(STOPPED)
    container.setDescription("")

    container
  }
}

object BlockReader {

  def apply(blockNode: Node): BlockReader = blockNode match {
    case CompositeBlockReader(compositeReader) =>
      compositeReader

    case StepBlockReader(stepBlock) =>
      stepBlock

    case PhaseReader(phaseReader) =>
      phaseReader

    case PhaseContainerReader(phaseReader) =>
      phaseReader

  }

  val MODEL_UP_TO_DATE = true
  val DEPRECATED_MODEL = true
}

object RootBlockReader {

  def apply(blockNode: Node): BlockReader = blockNode match {
    case PhaseContainerReader(containerReader) =>
      containerReader

    case CompositeBlockReader(compositeReader) =>
      compositeReader

    case StepBlockReader(stepBlockReader) =>
      stepBlockReader

    case PhaseReader(phaseReader) =>
      phaseReader

    case _ => new BlockReader {

      override def readFirstBlock(taskNode: Node, loadSteps: Boolean): ArchivedPhaseContainer = {
        new StepReader().readFirstBlock(taskNode, loadSteps)

      }

      override def read(blockNode: Node, loadSteps: Boolean, uptodateModel: Boolean): BlockState = {
        ???
      }
    }

  }

}