package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class FilterSimilarDeployedsGenerator extends AbstractChainGenerator {

    private static final Logger LOG = LoggerFactory.getLogger(FilterSimilarDeployedsGenerator.class);

    public FilterSimilarDeployedsGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        Optional<Deployed> existingDeployedMaybe = deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container);
        Type newDeployedType = deploymentContext.getTypeSupplier().getType(deployable, container);
        if (existingDeployedMaybe.isPresent()) {
            Deployed existingDeployed = existingDeployedMaybe.get();
            if (existingDeployed.getType().equals(newDeployedType)) {
                LOG.debug("New deployable {} is similar to existing deployed {}", deployable.getId(), existingDeployed.getId());
                return nextGenerator.generateDeployed(deploymentContext, deployable, container);
            }
        }
        LOG.debug("New deployable {} is NOT similar to existing deployed", deployable.getId());
        return new GeneratedDeployeds();
    }
}
