package com.xebialabs.deployit.service.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;

import com.xebialabs.deployit.engine.tasker.BlockBuilders;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import org.springframework.stereotype.Component;

import static com.xebialabs.deployit.task.TaskMetadata.TASK_TYPE;
import static com.xebialabs.deployit.task.TaskMetadata.putMetadata;

@Component
public class DiscoveryService {

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);

        String description = "Inspection of " + ci.getId();
        PhaseContainer stepBlock = BlockBuilders.steps(description, null, Lists.<StepState>newArrayList()).build();

        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        putMetadata(spec, TASK_TYPE, TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        DiscoveryResult retrieve = DiscoveryResults.retrieve(taskId);
        Preconditions.checkArgument(retrieve != null, "Could not find any results associated with the id [%s]", taskId);
        return retrieve;
    }
}
