/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment.setter;

import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.service.deployment.setter.AbstractPropertySetter;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FallbackPropertySetter
extends AbstractPropertySetter {
    private static final Logger logger = LoggerFactory.getLogger(FallbackPropertySetter.class);

    @Autowired
    public FallbackPropertySetter(RepositoryService repository) {
        super(repository);
    }

    private void checkWhetherValueIsSecureAndPropertyIsPassword(Object value, PropertyDescriptor deployedDesc, Object deployablePropertyValue) throws DictionaryValueException {
        if (value instanceof EncryptedStringValue && !deployedDesc.isPassword()) {
            logger.warn("The deployable value [{}] resolved to an encrypted value, but property [{}] is not a password field.", deployablePropertyValue, (Object)deployedDesc.getFqn());
            throw new DictionaryValueException("The deployable value [%s] resolved to an encrypted value, but property [%s] is not a password field.", new Object[]{deployablePropertyValue, deployedDesc.getFqn()});
        }
    }

    @Override
    public void setProperty(ConfigurationItem currentTarget, ConfigurationItem previousTarget, ConfigurationItem currentSource, ConfigurationItem previousSource, ConsolidatedDictionary dictionary, PropertyDescriptor targetPropertyDescriptor) {
        String name = targetPropertyDescriptor.getName();
        Object previousTargetValue = this.getValueIfExists(previousTarget, name);
        Object previousSourceValue = this.getValueIfExists(previousSource, name);
        Object currentSourceValue = this.getValueIfExists(currentSource, name);
        PropertyDescriptor sourcePropDesc = currentSource.getType().getDescriptor().getPropertyDescriptor(name);
        Object valueToSet = previousTargetValue;
        PropertyDescriptor valueToSetPropDesc = targetPropertyDescriptor;
        if (previousSourceValue != null && MustachePlaceholderScanner.hasPlaceholders((Object)previousSourceValue, (PropertyDescriptor)sourcePropDesc)) {
            valueToSet = currentSourceValue;
            valueToSetPropDesc = sourcePropDesc;
        } else if (previousSourceValue == null && currentSourceValue != null) {
            valueToSet = currentSourceValue;
            valueToSetPropDesc = sourcePropDesc;
        } else if (previousSourceValue != null) {
            PropertyDescriptor previousSourcePropDesc = previousSource.getType().getDescriptor().getPropertyDescriptor(name);
            Object resolvedPreviousSourceValue = this.convertIfNeeded(previousSourceValue, previousSourcePropDesc, targetPropertyDescriptor);
            if (previousTargetValue != null && resolvedPreviousSourceValue.toString().equals(previousTargetValue.toString())) {
                valueToSet = currentSourceValue;
                valueToSetPropDesc = sourcePropDesc;
            }
        }
        if (this.isNullOrEmpty(valueToSet, valueToSetPropDesc)) {
            this.setDeployedFromDictionary(currentTarget, dictionary, targetPropertyDescriptor, sourcePropDesc);
            return;
        }
        try {
            HashSet missingPlaceholdersAggregator = new HashSet();
            Object deployedPropertyValue = dictionary.resolve(valueToSet, valueToSetPropDesc, missingPlaceholdersAggregator);
            if (!missingPlaceholdersAggregator.isEmpty() && previousTargetValue != null) {
                throw new DictionaryValueException("Placeholder values could not be replaced in %s", new Object[]{missingPlaceholdersAggregator});
            }
            this.checkWhetherValueIsSecureAndPropertyIsPassword(deployedPropertyValue, targetPropertyDescriptor, valueToSet);
            this.setSilently(currentTarget, targetPropertyDescriptor, this.convertIfNeeded(deployedPropertyValue, valueToSetPropDesc, targetPropertyDescriptor));
        }
        catch (DictionaryValueException e) {
            this.setSilently(currentTarget, targetPropertyDescriptor, previousTargetValue);
            logger.info("Could not resolve dictionary keys for property " + sourcePropDesc + " on " + currentTarget + ".");
            logger.trace("Exception was", (Throwable)e);
        }
    }
}

