/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.planner.CheckPointManagerListener;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.overthere.local.LocalFile;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0005\u000b\u0001UA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)\u0011\u0007\u0001C\u0001e!)Q\t\u0001C\u0001\r\")q\n\u0001C\u0005!\")q\u000e\u0001C\u0005a\")1\u0010\u0001C\u0005y\")a\u0010\u0001C\u0005\u007f\ny!k\u001c7mE\u0006\u001c7nU3sm&\u001cWM\u0003\u0002\f\u0019\u0005QA-\u001a9m_flWM\u001c;\u000b\u00055q\u0011aB:feZL7-\u001a\u0006\u0003\u001fA\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003#I\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003M\t1aY8n\u0007\u0001\u00192\u0001\u0001\f\u001d!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0006g24GG\u001b\u0006\u0002C\u0005AqM]5{u2,G-\u0003\u0002$=\t9Aj\\4hS:<\u0017AB3oO&tW\r\u0005\u0002'U5\tqE\u0003\u0002)S\u00051A/Y:lKJT!\u0001\n\b\n\u0005-:#aB%F]\u001eLg.Z\u0001\u0012I\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0007C\u0001\u00180\u001b\u0005Q\u0011B\u0001\u0019\u000b\u0005E!U\r\u001d7ps6,g\u000e^*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M\"T\u0007\u0005\u0002/\u0001!)Ae\u0001a\u0001K!)Af\u0001a\u0001[!\u00121a\u000e\t\u0003q\rk\u0011!\u000f\u0006\u0003um\n!\"\u00198o_R\fG/[8o\u0015\taT(A\u0004gC\u000e$xN]=\u000b\u0005yz\u0014!\u00022fC:\u001c(B\u0001!B\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Es\tI\u0011)\u001e;po&\u0014X\rZ\u0001\te>dGNY1dWR\u0011qI\u0013\t\u0003M!K!!S\u0014\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g\u000eC\u0003L\t\u0001\u0007A*\u0001\u0003uCN\\\u0007C\u0001\u0014N\u0013\tquE\u0001\u0003UCN\\\u0017aG2sK\u0006$XMU8mY\n\f7m[*qK\u000eLg-[2bi&|g\u000e\u0006\u0003H#J[\u0006\"B&\u0006\u0001\u0004a\u0005\"B*\u0006\u0001\u0004!\u0016\u0001\u00069beRL\u0017\r\\\"p[6LG\u000f\u0016:jO\u001e,'\u000f\u0005\u0002V36\taK\u0003\u0002X1\u00069\u0001\u000f\\1o]\u0016\u0014(BA\u0006\u000f\u0013\tQfKA\rDQ\u0016\u001c7\u000eU8j]Rl\u0015M\\1hKJd\u0015n\u001d;f]\u0016\u0014\b\"\u0002/\u0006\u0001\u0004i\u0016\u0001C<pe.$\u0015N]:\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!\rF\u0001\u0007yI|w\u000e\u001e \n\u0003eI!!\u001a\r\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0005\u0019&\u001cHO\u0003\u0002f1A\u0011!.\\\u0007\u0002W*\u0011AND\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u00018l\u0005\u001d9vN]6ESJ\f\u0011cZ3u/>\u00148\u000eZ5s\u00072,\u0017M\\3s)\t\th\u000f\u0005\u0002si6\t1O\u0003\u0002L\u001d%\u0011Qo\u001d\u0002\u0016/>\u00148\u000eZ5s\u00072,\u0017M\\3s)JLwmZ3s\u0011\u00159h\u00011\u0001y\u0003\u001d\u0019wN\u001c;fqR\u0004\"AJ=\n\u0005i<#\u0001\u0006+bg.,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u000fhKR\u001c\u0005.Z2l!>Lg\u000e^'b]\u0006<WM\u001d'jgR,g.\u001a:\u0015\u0005Qk\b\"B<\b\u0001\u0004A\u0018aB1sG\"Lg/\u001a\u000b\u0005\u0003\u0003\t9\u0001E\u0002\u0018\u0003\u0007I1!!\u0002\u0019\u0005\u0011)f.\u001b;\t\u000b-C\u0001\u0019\u0001')\u0007\u0001\tY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\tbP\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u000b\u0003\u001f\u0011\u0011bQ8na>tWM\u001c;")
public class RollbackService
implements Logging {
    private final IEngine engine;
    private final DeploymentService deploymentService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RollbackService rollbackService = this;
        synchronized (rollbackService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskSpecification rollback(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Going to rollback task ").append(task.getId()).toString());
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getWorkdirCleaner(context);
        workdirCleanerTrigger.setKeepWorkdirsIntactOnTaskEnd(true);
        CheckPointManagerListener checkPointManagerListener = this.getCheckPointManagerListener(context);
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, checkPointManagerListener, (List<WorkDir>)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(workdirCleanerTrigger.getWorkDirs()).toList());
        this.archive(task);
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"taskType", (String)TaskType.ROLLBACK.name());
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"rollbackTask", (String)task.getId());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, CheckPointManagerListener partialCommitTrigger, List<WorkDir> workDirs) {
        workDirs.foreach((Function1 & Serializable & scala.Serializable)wd -> {
            RollbackService.$anonfun$createRollbackSpecification$1(this, wd);
            return BoxedUnit.UNIT;
        });
        MultiDeltaSpecification rollbackSpec = partialCommitTrigger.checkpointManager().prepareRollback();
        return this.deploymentService.getTaskFullSpecification(rollbackSpec, task.getWorkDir(), (WorkDir[])workDirs.toArray(ClassTag$.MODULE$.apply(WorkDir.class)));
    }

    private WorkdirCleanerTrigger getWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        return (WorkdirCleanerTrigger)context.getAttribute(name);
    }

    private CheckPointManagerListener getCheckPointManagerListener(TaskExecutionContext context) {
        String name = CheckPointManagerListener.class.getName();
        return (CheckPointManagerListener)context.getAttribute(name);
    }

    private void archive(Task task) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null)) {
            this.engine.archive(task.getId());
        } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED}))).contains((Object)task.getState())) {
            this.engine.cancel(task.getId());
        } else {
            throw new IllegalStateException(new StringBuilder(67).append("Can only rollback a STOPPED, FAILED, ABORTED or EXECUTED task [").append(task.getId()).append(" (").append(task.getState()).append(")]").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$createRollbackSpecification$1(RollbackService $this, WorkDir wd) {
        block0: {
            LocalFile from = LocalFile.from((File)new File(wd.getPath()));
            if (from.exists()) break block0;
            $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Re-creating workdir ").append(from.getPath()).append(" because it was deleted by the original deployment.").toString());
            from.mkdir();
        }
    }

    @Autowired
    public RollbackService(IEngine engine, DeploymentService deploymentService) {
        this.engine = engine;
        this.deploymentService = deploymentService;
        Logging.$init$((Logging)this);
    }
}

