/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.xebialabs.deployit.engine.spi.artifact.resolution.ResolvedArtifactFile;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.io.ArtifactFileUtils;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportedPackage;
import com.xebialabs.deployit.server.api.importer.Importer;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.importer.ListableImporter;
import com.xebialabs.deployit.server.api.importer.PackageInfo;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.DefaultImportingContext;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.deployit.service.importer.ImporterService;
import com.xebialabs.deployit.service.importer.XmlManifestDarImporter;
import com.xebialabs.deployit.service.importer.package$;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xldeploy.packager.SourceArtifactEnricher;
import com.xebialabs.xldeploy.packager.StreamFile;
import com.xebialabs.xlplatform.artifact.resolution.ArtifactResolverRegistry$;
import com.xebialabs.xlplatform.utils.ResourceManagement$;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import nl.javadude.scannit.Scannit;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001\u0002\u0017.\u0001aB\u0001\"\u0012\u0001\u0003\u0002\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0019!C\u0001\u001d\"Aq\u000b\u0001B\u0001B\u0003&q\t\u0003\u0005Y\u0001\t\u0005\r\u0011\"\u0001Z\u0011!\u0001\u0007A!a\u0001\n\u0003\t\u0007\u0002C2\u0001\u0005\u0003\u0005\u000b\u0015\u0002.\t\u0011\u0011\u0004!\u00111A\u0005\u0002\u0015D\u0001\u0002\u001c\u0001\u0003\u0002\u0004%\t!\u001c\u0005\t_\u0002\u0011\t\u0011)Q\u0005M\"A\u0001\u000f\u0001BA\u0002\u0013\u0005\u0011\u000f\u0003\u0005{\u0001\t\u0005\r\u0011\"\u0001|\u0011!i\bA!A!B\u0013\u0011\b\"\u0002@\u0001\t\u0003y\b\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\tY\u0005\u0001Q\u0001\n\u00055\u0002\"CA'\u0001\t\u0007I\u0011BA(\u0011!\ti\u0006\u0001Q\u0001\n\u0005E\u0003\"CA0\u0001\t\u0007I\u0011BA1\u0011!\t\t\t\u0001Q\u0001\n\u0005\r\u0004bCAB\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bC1\"a%\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0016\"Y\u0011\u0011\u0014\u0001A\u0002\u0003\u0005\u000b\u0015BAD\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a,\u0001\t\u0003\n\t\fC\u0004\u00024\u0002!\t!!.\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0007bBAr\u0001\u0011E\u0011Q\u001d\u0005\b\u0003s\u0004A\u0011BA~\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007AqA!\b\u0001\t\u0013\u0011y\u0002C\u0004\u00036\u0001!IAa\u000e\t\u000f\t5\u0003\u0001\"\u0003\u0003P!9!Q\u000b\u0001\u0005\n\t]\u0003b\u0002B2\u0001\u0011%!Q\r\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u00119\n\u0001C\u0005\u00053CqA!)\u0001\t\u0013\u0011\u0019\u000bC\u0004\u0003l\u0001!IA!+\t\u000f\t5\u0006\u0001\"\u0003\u00030\"9!1\u0017\u0001\u0005\n\tU\u0006b\u0002B`\u0001\u0011%!\u0011\u0019\u0005\b\u0003G\u0004A\u0011\u0002Bd\u0005MIU\u000e]8si\u0016\u00148+\u001a:wS\u000e,\u0017*\u001c9m\u0015\tqs&\u0001\u0005j[B|'\u000f^3s\u0015\t\u0001\u0014'A\u0004tKJ4\u0018nY3\u000b\u0005I\u001a\u0014\u0001\u00033fa2|\u00170\u001b;\u000b\u0005Q*\u0014!\u0003=fE&\fG.\u00192t\u0015\u00051\u0014aA2p[\u000e\u00011c\u0001\u0001:\u0003B\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB(cU\u0016\u001cG\u000f\u0005\u0002C\u00076\tQ&\u0003\u0002E[\ty\u0011*\u001c9peR,'oU3sm&\u001cW-A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015F\n!B]3q_NLGo\u001c:z\u0013\ta\u0015JA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\fQC]3q_NLGo\u001c:z'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0002P+B\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n!QK\\5u\u0011\u001d1&!!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0003I\u0011X\r]8tSR|'/_*feZL7-\u001a\u0011\u0002\u0017I|G.Z*feZL7-Z\u000b\u00025B\u00111LX\u0007\u00029*\u0011Q,M\u0001\tg\u0016\u001cWO]5us&\u0011q\f\u0018\u0002\f%>dWmU3sm&\u001cW-A\bs_2,7+\u001a:wS\u000e,w\fJ3r)\ty%\rC\u0004W\u000b\u0005\u0005\t\u0019\u0001.\u0002\u0019I|G.Z*feZL7-\u001a\u0011\u0002\u0013Y\fG.\u001b3bi>\u0014X#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%|\u0013A\u0003<bY&$\u0017\r^5p]&\u00111\u000e\u001b\u0002\n-\u0006d\u0017\u000eZ1u_J\fQB^1mS\u0012\fGo\u001c:`I\u0015\fHCA(o\u0011\u001d1\u0006\"!AA\u0002\u0019\f!B^1mS\u0012\fGo\u001c:!\u0003!)gN]5dQ\u0016\u0014X#\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018\u0001\u00039bG.\fw-\u001a:\u000b\u0005]\u001c\u0014\u0001\u0003=mI\u0016\u0004Hn\\=\n\u0005e$(AF*pkJ\u001cW-\u0011:uS\u001a\f7\r^#oe&\u001c\u0007.\u001a:\u0002\u0019\u0015t'/[2iKJ|F%Z9\u0015\u0005=c\bb\u0002,\f\u0003\u0003\u0005\rA]\u0001\nK:\u0014\u0018n\u00195fe\u0002\na\u0001P5oSRtDCCA\u0001\u0003\u0007\t)!a\u0002\u0002\nA\u0011!\t\u0001\u0005\u0006\u000b6\u0001\ra\u0012\u0005\u000616\u0001\rA\u0017\u0005\u0006I6\u0001\rA\u001a\u0005\u0006a6\u0001\rA\u001d\u0015\u0004\u001b\u00055\u0001\u0003BA\b\u0003Ki!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\f\u00033\tqAZ1di>\u0014\u0018P\u0003\u0003\u0002\u001c\u0005u\u0011!\u00022fC:\u001c(\u0002BA\u0010\u0003C\tqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003G\t1a\u001c:h\u0013\u0011\t9#!\u0005\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!C5na>\u0014H/\u001a:t+\t\ti\u0003\u0005\u0004\u00020\u0005U\u0012\u0011H\u0007\u0003\u0003cQ1!a\r>\u0003\u0011)H/\u001b7\n\t\u0005]\u0012\u0011\u0007\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002<\u0005\u001dSBAA\u001f\u0015\rq\u0013q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0002ba&T1!!\u00122\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011JA\u001f\u0005!IU\u000e]8si\u0016\u0014\u0018AC5na>\u0014H/\u001a:tA\u00051An\\4hKJ,\"!!\u0015\u0011\t\u0005M\u0013\u0011L\u0007\u0003\u0003+RA!a\u0016\u0002\"\u0005)1\u000f\u001c45U&!\u00111LA+\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001E5t\u0007>dG.Z2uS>t7*\u001b8e+\t\t\u0019\u0007E\u0004Q\u0003K\nI'a\u001f\n\u0007\u0005\u001d\u0014KA\u0005Gk:\u001cG/[8ocA!\u00111NA<\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014a\u0002:fM2,7\r\u001e\u0006\u0005\u0003\u0003\n\u0019HC\u0002\u0002vE\na\u0001\u001d7vO&t\u0017\u0002BA=\u0003[\u0012A\u0002\u0015:pa\u0016\u0014H/_&j]\u0012\u00042\u0001UA?\u0013\r\ty(\u0015\u0002\b\u0005>|G.Z1o\u0003EI7oQ8mY\u0016\u001cG/[8o\u0017&tG\rI\u0001\u001bS6\u0004xN\u001d;bE2,\u0007+Y2lC\u001e,G)\u001b:fGR|'/_\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001bk\u0014AA5p\u0013\u0011\t\t*a#\u0003\t\u0019KG.Z\u0001\u001fS6\u0004xN\u001d;bE2,\u0007+Y2lC\u001e,G)\u001b:fGR|'/_0%KF$2aTAL\u0011!1V#!AA\u0002\u0005\u001d\u0015aG5na>\u0014H/\u00192mKB\u000b7m[1hK\u0012K'/Z2u_JL\b%A\u0007j]&$\u0018*\u001c9peR,'o\u001d\u000b\u0002\u001f\"\u001aq#!)\u0011\t\u0005\r\u00161V\u0007\u0003\u0003KSA!a\u0005\u0002(*\u0011\u0011\u0011V\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003[\u000b)KA\u0007Q_N$8i\u001c8tiJ,8\r^\u0001\u001eO\u0016$\u0018*\u001c9peR\f'\r\\3QC\u000e\\\u0017mZ3ESJ,7\r^8ssR\u0011\u0011qQ\u0001\u001eg\u0016$\u0018*\u001c9peR\f'\r\\3QC\u000e\\\u0017mZ3ESJ,7\r^8ssR\u0019q*a.\t\u000f\u0005\r\u0015\u00041\u0001\u0002\b\u0006aA.[:u!\u0006\u001c7.Y4fgR\u0011\u0011Q\u0018\t\u0007\u0003_\t)$a0\u0011\t\u0005\u0005\u0017q\u001a\b\u0005\u0003\u0007\fY\rE\u0002\u0002FFk!!a2\u000b\u0007\u0005%w'\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001b\f\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0006M'AB*ue&twMC\u0002\u0002NF\u000bQ\"[7q_J$\b+Y2lC\u001e,G\u0003BA`\u00033Dq!a7\u001c\u0001\u0004\ti.\u0001\u0004t_V\u00148-\u001a\t\u0005\u0003w\ty.\u0003\u0003\u0002b\u0006u\"\u0001D%na>\u0014HoU8ve\u000e,\u0017aD2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\u000b=\u000b9/!>\t\u000f\u0005%H\u00041\u0001\u0002l\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u0011\t\u00055\u0018\u0011_\u0007\u0003\u0003_T1!!;]\u0013\u0011\t\u00190a<\u0003\u0015A+'/\\5tg&|g\u000eC\u0004\u0002xr\u0001\r!a0\u0002)=t7i\u001c8gS\u001e,(/\u0019;j_:LE/Z7t\u0003!!w.S7q_J$HCBA`\u0003{\fy\u0010C\u0004\u0002\\v\u0001\r!!8\t\r9j\u0002\u0019AA\u001d\u00039\u0001XO\u00197jg\"\u001cu.\\7b]\u0012$2a\u0014B\u0003\u0011\u001d\u00119A\ba\u0001\u0005\u0013\tQ!\u001a<f]R\u0004BAa\u0003\u0003\u001a5\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0004d_6l\u0017M\u001c3\u000b\t\tM!QC\u0001\u0004gBL'b\u0001B\fc\u00051QM\\4j]\u0016LAAa\u0007\u0003\u000e\t)\"+\u001a9pg&$xN]=CCN,7i\\7nC:$\u0017\u0001E:dC:\u0004F.Y2fQ>dG-\u001a:t)\u0015y%\u0011\u0005B\u0016\u0011\u001d\u0011\u0019c\ba\u0001\u0005K\tq\"[7q_J$X\r\u001a)bG.\fw-\u001a\t\u0005\u0003w\u00119#\u0003\u0003\u0003*\u0005u\"aD%na>\u0014H/\u001a3QC\u000e\\\u0017mZ3\t\u000f\t5r\u00041\u0001\u00030\u0005\u00191\r\u001e=\u0011\t\u0005m\"\u0011G\u0005\u0005\u0005g\tiD\u0001\tJ[B|'\u000f^5oO\u000e{g\u000e^3yi\u0006A\"/Z:pYZ,\u0017I\u001c3F]JL7\r[!si&4\u0017m\u0019;\u0015\u0007=\u0013I\u0004C\u0004\u0003<\u0001\u0002\rA!\u0010\u0002\u001dM|WO]2f\u0003J$\u0018NZ1diB!!q\bB%\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013\u0001C1si&4\u0017m\u0019;\u000b\t\t\u001d\u0013\u0011O\u0001\u0004k\u0012l\u0017\u0002\u0002B&\u0005\u0003\u0012abU8ve\u000e,\u0017I\u001d;jM\u0006\u001cG/A\u000bjg\u0006\u0013H/\u001b4bGR\u0004&/Z#oe&\u001c\u0007.\u001a3\u0015\t\u0005m$\u0011\u000b\u0005\b\u0005'\n\u0003\u0019\u0001B\u001f\u0003)!W\r\u001d7ps\u0006\u0014G.Z\u0001\u000eG\",7m[%na>\u0014H/\u001a3\u0015\u0007=\u0013I\u0006C\u0004\u0003\\\t\u0002\rA!\u0018\u0002\u0017A\f7m[1hK&sgm\u001c\t\u0005\u0003w\u0011y&\u0003\u0003\u0003b\u0005u\"a\u0003)bG.\fw-Z%oM>\fab\u0019:fCR,WI\u001c;ji&,7\u000fF\u0004P\u0005O\u0012IG!\u001c\t\u000f\t\r2\u00051\u0001\u0003&!9!1N\u0012A\u0002\u0005m\u0014!C5t+B<'/\u00193f\u0011\u001d\u0011yg\ta\u0001\u0005c\n\u0011\u0003^8De\u0016\fG/Z\"pY2,7\r^8s!\u0019\tyCa\u001d\u0003x%!!QOA\u0019\u0005\r\u0019V\r\u001e\t\u0005\u0005s\u0012Y(\u0004\u0002\u0003F%!!Q\u0010B#\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\\\u0001\u0017M&dG/\u001a:Fq&\u001cH/\u001b8h!\u0006\u001c7.Y4fgR!!1\u0011BG!\u0019\t\tM!\"\u0003\b&!!QOAj!\u0011\tYG!#\n\t\t-\u0015Q\u000e\u0002\u0013!J|\u0007/\u001a:us\u0012+7o\u0019:jaR|'\u000fC\u0004\u0003\u0010\u0012\u0002\rA!%\u0002\u000fY,'o]5p]B!!\u0011\u0010BJ\u0013\u0011\u0011)J!\u0012\u0003\u000fY+'o]5p]\u0006q2M]3bi\u0016tUm\u001d;fI\u000e{gNZ5hkJ\fG/[8o\u0013R,Wn\u001d\u000b\u0006\u001f\nm%q\u0014\u0005\b\u0005;+\u0003\u0019\u0001B<\u0003\t\u0019\u0017\u000eC\u0004\u0003p\u0015\u0002\rA!\u001d\u0002\u0011Y\fG.\u001b3bi\u0016$2a\u0014BS\u0011\u001d\u00119K\na\u0001\u0005c\n\u0001\u0002^8De\u0016\fG/\u001a\u000b\u0005\u0003w\u0012Y\u000bC\u0004\u0003\\\u001d\u0002\rA!\u0018\u0002\u000f\u0005\u0004\bOT1nKR!\u0011q\u0018BY\u0011\u001d\u0011Y\u0006\u000ba\u0001\u0005;\n!c];c'R\u0014\u0018N\\4BMR,'\u000fT1tiR1\u0011q\u0018B\\\u0005wCqA!/*\u0001\u0004\ty,A\u0001t\u0011\u001d\u0011i,\u000ba\u0001\u0003\u007f\u000b1a]3q\u0003M\u0019XOY*ue&twMQ3g_J,G*Y:u)\u0019\tyLa1\u0003F\"9!\u0011\u0018\u0016A\u0002\u0005}\u0006b\u0002B_U\u0001\u0007\u0011q\u0018\u000b\u0006\u001f\n%'1\u001a\u0005\b\u0005WZ\u0003\u0019AA>\u0011\u001d\u0011Yf\u000ba\u0001\u0005;\u0002")
public class ImporterServiceImpl
implements ImporterService {
    private RepositoryService repositoryService;
    private RoleService roleService;
    private Validator validator;
    private SourceArtifactEnricher enricher;
    private final java.util.List<Importer> importers;
    private final Logger logger;
    private final Function1<PropertyKind, Object> isCollectionKind;
    private File importablePackageDirectory;

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public void repositoryService_$eq(RepositoryService x$1) {
        this.repositoryService = x$1;
    }

    public RoleService roleService() {
        return this.roleService;
    }

    public void roleService_$eq(RoleService x$1) {
        this.roleService = x$1;
    }

    public Validator validator() {
        return this.validator;
    }

    public void validator_$eq(Validator x$1) {
        this.validator = x$1;
    }

    public SourceArtifactEnricher enricher() {
        return this.enricher;
    }

    public void enricher_$eq(SourceArtifactEnricher x$1) {
        this.enricher = x$1;
    }

    private java.util.List<Importer> importers() {
        return this.importers;
    }

    private Logger logger() {
        return this.logger;
    }

    private Function1<PropertyKind, Object> isCollectionKind() {
        return this.isCollectionKind;
    }

    private File importablePackageDirectory() {
        return this.importablePackageDirectory;
    }

    private void importablePackageDirectory_$eq(File x$1) {
        this.importablePackageDirectory = x$1;
    }

    @PostConstruct
    public void initImporters() {
        Set importerClasses = Scannit.getInstance().getSubTypesOf(Importer.class);
        this.logger().debug("Found importers: {}", new Object[]{importerClasses});
        ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(importerClasses).filter((Function1 & Serializable & scala.Serializable)cls -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$1(cls)))).foreach((Function1 & Serializable & scala.Serializable)importerClass -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$initImporters$2(this, importerClass)));
        this.importers().sort((o1, o2) -> o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName()));
        this.importers().add((Importer)new XmlManifestDarImporter(this.repositoryService()));
        this.logger().debug("Importer {} registered.", new Object[]{XmlManifestDarImporter.class});
        this.logger().info("Importers configured in XL Deploy: {}", new Object[]{this.importers()});
    }

    @Override
    public File getImportablePackageDirectory() {
        return this.importablePackageDirectory();
    }

    public void setImportablePackageDirectory(File importablePackageDirectory) {
        this.importablePackageDirectory_$eq(importablePackageDirectory);
    }

    @Override
    public java.util.List<String> listPackages() {
        return Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((SeqLike)List$.MODULE$.apply((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.importers())).withFilter((Function1 & Serializable & scala.Serializable)importer -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$listPackages$1(importer))).flatMap((Function1 & Serializable & scala.Serializable)importer -> (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(((ListableImporter)importer).list(this.importablePackageDirectory())).map((Function1 & Serializable & scala.Serializable)pkgFound -> pkgFound, Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).asJava()));
    }

    @Override
    public String importPackage(ImportSource source) {
        String string;
        try {
            Option option = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.importers()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canHandle(source)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new ImporterException("The selected file does not have the expected format for an importable package", new Object[0]);
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Importer importer = (Importer)some.value();
            String string2 = this.doImport(source, importer);
            string = string2;
        }
        finally {
            source.cleanUp();
        }
        return string;
    }

    public void checkPermission(Permission permission, String onConfigurationItems) {
        if (!permission.getPermissionHandler().hasPermission(onConfigurationItems)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)onConfigurationItems);
        }
    }

    private String doImport(ImportSource source, Importer importer) {
        String string;
        DefaultImportingContext ctx = new DefaultImportingContext();
        PackageInfo packageInfo = importer.preparePackage(source, (ImportingContext)ctx);
        try {
            boolean upgrade = this.isUpgrade(packageInfo);
            this.checkPermission(upgrade, packageInfo);
            this.checkImported(packageInfo);
            ImportedPackage importedPackage = importer.importEntities(packageInfo, (ImportingContext)ctx);
            this.scanPlaceholders(importedPackage, ctx);
            HashSet toCreate = Sets.newHashSet();
            this.createEntities(importedPackage, upgrade, toCreate);
            this.validate(toCreate);
            if (upgrade) {
                importedPackage.getVersion().setApplication((Application)this.repositoryService().read(packageInfo.getApplicationId()));
            }
            CreateCisCommand event = new CreateCisCommand((java.util.List)Lists.newArrayList((Iterable)toCreate));
            this.publishCommand((RepositoryBaseCommand)event);
            string = importedPackage.getVersion().getId();
        }
        finally {
            importer.cleanUp(packageInfo, (ImportingContext)ctx);
        }
        return string;
    }

    private void publishCommand(RepositoryBaseCommand event) {
        List roles = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.roleService().getRolesFor(Permissions.getAuthentication())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Buffer$.MODULE$.canBuildFrom())).toList();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)roles));
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    private void scanPlaceholders(ImportedPackage importedPackage, ImportingContext ctx) {
        block0: {
            if (!(importedPackage.getVersion() instanceof DeploymentPackage)) break block0;
            ((java.util.List)ctx.getAttribute("temporaryFiles")).add(new TFile(Files.createTempDir()));
            JavaConversions$.MODULE$.deprecated$u0020asScalaSet(package$.MODULE$.getAllArtifacts(importedPackage.getDeployables())).foreach((Function1 & Serializable & scala.Serializable)sourceArtifact -> {
                ImporterServiceImpl.$anonfun$scanPlaceholders$1(this, sourceArtifact);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void resolveAndEnrichArtifact(SourceArtifact sourceArtifact) {
        try {
            ResourceManagement$.MODULE$.using((Closeable)ArtifactResolverRegistry$.MODULE$.resolve(sourceArtifact), (Function1 & Serializable & scala.Serializable)resolve -> {
                ResourceManagement$.MODULE$.using((Closeable)resolve.openStream(), (Function1 & Serializable & scala.Serializable)is -> {
                    ImporterServiceImpl.$anonfun$resolveAndEnrichArtifact$2($this, sourceArtifact$1, resolve, is);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (IOException iOException) {
            throw new ImporterException(new StringBuilder(53).append("Could not open stream of uri ").append(sourceArtifact.getFileUri()).append(" of unresolved artifact ").append(sourceArtifact).toString(), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isArtifactPreEnriched(SourceArtifact deployable) {
        void var2_2;
        boolean isPreEnrichedArtifact = deployable.hasProperty("preEnrichedArtifact") && BoxesRunTime.unboxToBoolean((Object)deployable.getProperty("preEnrichedArtifact"));
        this.logger().info(new StringBuilder(26).append("Artifact ").append(deployable).append(" is ").append((Object)(isPreEnrichedArtifact ? "" : "not")).append(" pre-enriched").toString());
        return (boolean)var2_2;
    }

    private void checkImported(PackageInfo packageInfo) {
        String id = IdGenerator.generateId((String)packageInfo.getApplicationId(), (String)packageInfo.getApplicationVersion());
        if (this.repositoryService().exists(id)) {
            throw new ImporterException("Already imported version %s of application %s", packageInfo.getApplicationVersion(), packageInfo.getApplicationName());
        }
        String dirs = this.subStringBeforeLast(packageInfo.getApplicationId(), "/");
        if (!this.repositoryService().exists(dirs)) {
            throw new ImporterException("The directory structure [%s] specified for the import of application [%s] does not exist.", dirs, this.appName(packageInfo));
        }
    }

    private void createEntities(ImportedPackage importedPackage, boolean isUpgrade, Set<ConfigurationItem> toCreateCollector) {
        Object object = !isUpgrade ? BoxesRunTime.boxToBoolean((boolean)toCreateCollector.add((ConfigurationItem)importedPackage.getApplication())) : BoxedUnit.UNIT;
        Version version = importedPackage.getVersion();
        toCreateCollector.add((ConfigurationItem)version);
        this.filterExistingPackages(version).withFilter((Function1 & Serializable & scala.Serializable)pd -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createEntities$1(this, pd))).foreach((Function1 & Serializable & scala.Serializable)pd -> {
            ImporterServiceImpl.$anonfun$createEntities$2(this, version, toCreateCollector, pd);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<PropertyDescriptor> filterExistingPackages(Version version) {
        scala.collection.immutable.Set propertyDescriptors = JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(version.getType().getDescriptor().getPropertyDescriptors()).toSet();
        return !(version instanceof CompositePackage) ? propertyDescriptors : (scala.collection.immutable.Set)propertyDescriptors.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$filterExistingPackages$1(x$3)));
    }

    private void createNestedConfigurationItems(ConfigurationItem ci, Set<ConfigurationItem> toCreateCollector) {
        Collection propertyDescriptors = ci.getType().getDescriptor().getPropertyDescriptors();
        JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable(propertyDescriptors).withFilter((Function1 & Serializable & scala.Serializable)propertyDescriptor -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$1(this, propertyDescriptor))).foreach((Function1 & Serializable & scala.Serializable)propertyDescriptor -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$2(this, ci, toCreateCollector, propertyDescriptor);
            return BoxedUnit.UNIT;
        });
    }

    private void validate(Set<ConfigurationItem> toCreate) {
        scala.collection.mutable.Set msgs = (scala.collection.mutable.Set)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(toCreate).flatMap((Function1 & Serializable & scala.Serializable)toCreateEntity -> (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.validator().validate(toCreateEntity, (java.util.List)Lists.newArrayList((Iterable)toCreate))).map((Function1 & Serializable & scala.Serializable)msg -> msg, Buffer$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
        if (msgs.nonEmpty()) {
            throw new ImporterException("Import failed with the following validation errors %s", msgs.mkString(", "));
        }
    }

    private boolean isUpgrade(PackageInfo packageInfo) {
        boolean bl;
        boolean locationSpecified = packageInfo.getApplicationName().contains("/");
        List applications = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.repositoryService().list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(this.appName(packageInfo)).setAncestor(packageInfo.getApplicationRoot()))).toList();
        int n = applications.length();
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                if (locationSpecified) {
                    String string = ((ConfigurationItemData)applications.head()).getId();
                    String string2 = packageInfo.getApplicationId();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        throw new ImporterException("The manifest contains the path [%s] to import the application into, but the application exists at the path [%s]", packageInfo.getApplicationId(), ((ConfigurationItemData)applications.head()).getId());
                    }
                }
                String appId = ((ConfigurationItemData)applications.head()).getId();
                packageInfo.setDirectories(appId.substring(packageInfo.getApplicationRoot().length(), appId.length() - packageInfo.getApplicationName().length()));
                bl = true;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(43).append("Found more than 1 [").append(((ConfigurationItemData)applications.head()).getType()).append("] with the same name: [").append(applications.mkString(", ")).append("]").toString());
            }
        }
        return bl;
    }

    private String appName(PackageInfo packageInfo) {
        return this.subStringAfterLast(packageInfo.getApplicationId(), "/");
    }

    private String subStringAfterLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(s.lastIndexOf(sep) + sep.length());
    }

    private String subStringBeforeLast(String s, String sep) {
        return !s.contains(sep) ? s : s.substring(0, s.lastIndexOf(sep));
    }

    private void checkPermission(boolean isUpgrade, PackageInfo packageInfo) {
        Permission requiredPermission = isUpgrade ? DeployitPermissions.IMPORT_UPGRADE : DeployitPermissions.IMPORT_INITIAL;
        this.checkPermission(requiredPermission, packageInfo.getApplicationId());
    }

    public static final /* synthetic */ boolean $anonfun$isCollectionKind$1(PropertyKind kind) {
        return kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$initImporters$1(Class cls) {
        if (cls.isInterface()) return false;
        if (Modifier.isAbstract(cls.getModifiers())) return false;
        Class clazz = cls;
        Class<XmlManifestDarImporter> clazz2 = XmlManifestDarImporter.class;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$initImporters$2(ImporterServiceImpl $this, Class importerClass) {
        boolean bl;
        try {
            $this.logger().debug("Importer {} registered.", new Object[]{importerClass});
            bl = $this.importers().add((Importer)importerClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException(new StringBuilder(32).append("Could not instantiate importer: ").append(importerClass).toString(), e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$listPackages$1(Importer importer) {
        return importer instanceof ListableImporter;
    }

    public static final /* synthetic */ void $anonfun$scanPlaceholders$1(ImporterServiceImpl $this, SourceArtifact sourceArtifact) {
        if (ArtifactFileUtils.hasRealOrResolvedFile((Artifact)sourceArtifact)) {
            $this.logger().info("Artifact {} is a resolved artifact", new Object[]{sourceArtifact});
            if (!$this.isArtifactPreEnriched(sourceArtifact)) {
                $this.enricher().enrichArtifact(sourceArtifact);
            }
        } else {
            $this.logger().info(new StringBuilder(29).append("Resolving artifact ").append(sourceArtifact).append(" from url ").append(sourceArtifact.getFileUri()).toString());
            $this.resolveAndEnrichArtifact(sourceArtifact);
        }
    }

    public static final /* synthetic */ void $anonfun$resolveAndEnrichArtifact$2(ImporterServiceImpl $this, SourceArtifact sourceArtifact$1, ResolvedArtifactFile resolve$1, InputStream is) {
        if (!$this.isArtifactPreEnriched(sourceArtifact$1)) {
            $this.enricher().enrichArtifact(sourceArtifact$1, new StreamFile(resolve$1.getFileName(), is));
        }
        sourceArtifact$1.setFile(LocalFile.valueOf((File)new File(resolve$1.getFileName())));
    }

    public static final /* synthetic */ boolean $anonfun$createEntities$1(ImporterServiceImpl $this, PropertyDescriptor pd) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)pd.getKind()));
    }

    public static final /* synthetic */ void $anonfun$createEntities$2(ImporterServiceImpl $this, Version version$1, Set toCreateCollector$1, PropertyDescriptor pd) {
        Collection cis = (Collection)pd.get((ConfigurationItem)version$1);
        toCreateCollector$1.addAll(Sets.newHashSet((Iterable)cis));
        cis.forEach(ci -> $this.createNestedConfigurationItems((ConfigurationItem)ci, toCreateCollector$1));
    }

    public static final /* synthetic */ boolean $anonfun$filterExistingPackages$1(PropertyDescriptor x$3) {
        String string = x$3.getName();
        String string2 = "packages";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$1(ImporterServiceImpl $this, PropertyDescriptor propertyDescriptor) {
        return BoxesRunTime.unboxToBoolean((Object)$this.isCollectionKind().apply((Object)propertyDescriptor.getKind()));
    }

    public static final /* synthetic */ boolean $anonfun$createNestedConfigurationItems$3(Set toCreateCollector$2, ConfigurationItem embedded) {
        return !toCreateCollector$2.contains(embedded);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$4(ImporterServiceImpl $this, Set toCreateCollector$2, ConfigurationItem embedded) {
        toCreateCollector$2.add(embedded);
        $this.createNestedConfigurationItems(embedded, toCreateCollector$2);
    }

    public static final /* synthetic */ void $anonfun$createNestedConfigurationItems$2(ImporterServiceImpl $this, ConfigurationItem ci$1, Set toCreateCollector$2, PropertyDescriptor propertyDescriptor) {
        JavaConversions$.MODULE$.deprecated$u0020collectionAsScalaIterable((Collection)propertyDescriptor.get(ci$1)).withFilter((Function1 & Serializable & scala.Serializable)embedded -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$createNestedConfigurationItems$3(toCreateCollector$2, embedded))).foreach((Function1 & Serializable & scala.Serializable)embedded -> {
            ImporterServiceImpl.$anonfun$createNestedConfigurationItems$4($this, toCreateCollector$2, embedded);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ImporterServiceImpl(RepositoryService repositoryService, RoleService roleService, Validator validator, SourceArtifactEnricher enricher) {
        this.repositoryService = repositoryService;
        this.roleService = roleService;
        this.validator = validator;
        this.enricher = enricher;
        this.importers = Lists.newArrayList();
        this.logger = LoggerFactory.getLogger(ImporterServiceImpl.class);
        this.isCollectionKind = (Function1 & Serializable & scala.Serializable)kind -> BoxesRunTime.boxToBoolean((boolean)ImporterServiceImpl.$anonfun$isCollectionKind$1(kind));
    }
}

