/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.BaseProvisionable;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.service.deployment.DeployedApplicationFactory;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeployedProcessorsFactory;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedService {
    private final DeployedApplicationFactory deployedApplicationFactory;
    private final DeployedProcessorsFactory deployedProcessorsFactory;
    private static final Logger logger = LoggerFactory.getLogger(DeployedService.class);

    @Autowired
    public DeployedService(DeployedApplicationFactory deployedApplicationFactory, DeployedProcessorsFactory deployedProcessorsFactory) {
        this.deployedApplicationFactory = deployedApplicationFactory;
        this.deployedProcessorsFactory = deployedProcessorsFactory;
    }

    public DeployedApplication generateDeployedApplication(Type deployedApplicationType, Version version, Environment env, ConsolidatedDictionary consolidatedDictionary) {
        return this.deployedApplicationFactory.createDeployedApplication(deployedApplicationType, version, env, consolidatedDictionary);
    }

    public GeneratedDeployeds generateSelectedDeployeds(Deployment deployment, List<ConfigurationItem> deployableCis, Version version, Environment env) {
        return this.generateSelectedDeployeds(deployment, deployableCis, env.getMembers(), Dictionaries.of((Environment)env).filterBy(version));
    }

    public GeneratedDeployeds generateSelectedDeployeds(Deployment deployment, List<ConfigurationItem> deployableCis, Set<? extends Container> containers, Dictionaries dictionaries) {
        List deployables = Lists.transform(deployableCis, from -> {
            Checks.checkArgument((boolean)(from instanceof Deployable), (String)"The entity %s is not a deployable", (Object[])new Object[]{from.getId()});
            return (Deployable)from;
        });
        return this.generateDeployedsOfType(deployment, deployables, containers, null, dictionaries);
    }

    public GeneratedDeployeds createSelectedDeployed(Deployment deployment, Deployable deployable, Container container, Type deployedType, Version version, Environment env) {
        logger.debug("Creating deployed for [{}] and [{}]", (Object)deployable, (Object)container);
        Dictionaries dictionaries = Dictionaries.of((Environment)env).filterBy(version);
        return this.generateDeployedsOfType(deployment, Lists.newArrayList((Object[])new Deployable[]{deployable}), Lists.newArrayList((Object[])new Container[]{container}), deployedType, dictionaries, true);
    }

    public GeneratedDeployeds generateUpgradedDeployeds(DeployedApplication deployedApplication, Version newPackage) {
        Environment environment = deployedApplication.getEnvironment();
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        Dictionaries dictionaries = Dictionaries.of((Environment)environment).filterBy(newPackage);
        DeploymentContext deploymentContext = this.deployedProcessorsFactory.createContextForUpgrade(deployedApplication, dictionaries, deployedApplication.getDeployeds());
        DeployedGenerator deployedGenerator = this.deployedProcessorsFactory.createUpgradeDeployedGenerator();
        Set containers = deployedApplication.getDeployeds().stream().map(Deployed::getContainer).collect(Collectors.toSet());
        newPackage.getDeployables().stream().forEach(d -> {
            for (Container container : containers) {
                try {
                    generatedDeployeds.merge(deployedGenerator.generateDeployed(deploymentContext, (Deployable)d, container));
                }
                catch (Checks.IncorrectArgumentException exception) {
                    deployedApplication.get$validationMessages().add(ValidationMessage.error((String)d.getId(), null, (String)exception.getMessage()));
                }
            }
        });
        return generatedDeployeds;
    }

    public DeployedApplication generateUpdateDeployedApplication(DeployedApplication deployedApplication, Version newVersion, ConsolidatedDictionary dictionary) {
        return this.deployedApplicationFactory.createUpgradeDeployedApplication(newVersion, deployedApplication, dictionary);
    }

    public List<Deployed> createDeployedsForNonExistingCombinations(Deployment deployment, Version version, Environment environment, Set<Deployed> deployeds, Map<String, String> userProvidedPlaceholder) {
        Set deployables = version.getDeployables();
        Set members = environment.getMembers();
        List<Deployed> validExistingDeployeds = deployeds.stream().filter(input -> input.getDeployable() != null).collect(Collectors.toList());
        logger.debug("Valid existing deployeds: {}", validExistingDeployeds);
        List invalidExistingDeployeds = deployeds.stream().filter(input -> input.getDeployable() == null).collect(Collectors.toList());
        logger.debug("Invalid existing deployeds: {}", invalidExistingDeployeds);
        Dictionaries dictionaries = Dictionaries.of((Environment)environment).filterBy(version).withAdditionalEntries(userProvidedPlaceholder);
        GeneratedDeployeds generatedDeployeds = this.generateDeployedsOfType(deployment, deployables, members, null, dictionaries);
        logger.debug("Going to filter previously present deployeds");
        FilterSet filterSet = new FilterSet(validExistingDeployeds);
        generatedDeployeds.getDeployeds().forEach(filterSet::add);
        List<Deployed> allValidAsList = filterSet.getAllValidAsList();
        allValidAsList.addAll(invalidExistingDeployeds.stream().filter(d -> !allValidAsList.contains(d)).collect(Collectors.toList()));
        return allValidAsList;
    }

    private GeneratedDeployeds generateDeployedsOfType(Deployment deployment, Collection<? extends Deployable> deployables, Collection<? extends Container> containers, Type deployedType, Dictionaries dictionaries) {
        return this.generateDeployedsOfType(deployment, deployables, containers, deployedType, dictionaries, false);
    }

    private GeneratedDeployeds generateDeployedsOfType(Deployment deployment, Collection<? extends Deployable> deployables, Collection<? extends Container> containers, Type deployedType, Dictionaries dictionaries, boolean ignoreTags) {
        GeneratedDeployeds generatedDeployeds = new GeneratedDeployeds();
        DeployedGenerator deployedGenerator = ignoreTags ? this.deployedProcessorsFactory.createCoreDeployedGenerator() : this.deployedProcessorsFactory.createTagDeployedGenerator();
        DeploymentContext deploymentContext = deployedType != null ? this.deployedProcessorsFactory.createContextForSpecificType(deployment, dictionaries, deployedType) : this.deployedProcessorsFactory.createContextWithCalculatedType(deployment, dictionaries);
        for (Deployable deployable : deployables) {
            for (Container container : containers) {
                generatedDeployeds.merge(deployedGenerator.generateDeployed(deploymentContext, deployable, container));
            }
        }
        return generatedDeployeds;
    }

    public void scanMissingPlaceholders(DeployedApplication deployedApplication, Environment environment) {
        this.deployedApplicationFactory.scanMissingPlaceholders(deployedApplication, environment);
    }

    private static class Key {
        private String deployableId;
        private String containerId;

        private Key(String deployableId, String containerId) {
            this.deployableId = deployableId;
            this.containerId = containerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.containerId.equals(key.containerId) && this.deployableId.equals(key.deployableId);
        }

        public int hashCode() {
            int result = this.deployableId.hashCode();
            result = 31 * result + this.containerId.hashCode();
            return result;
        }
    }

    private static class Value {
        private Deployed deployed;
        private boolean valid;

        private Value(Deployed deployed) {
            this.deployed = deployed;
        }

        Value valid() {
            this.valid = true;
            return this;
        }

        private boolean isValid() {
            return this.valid;
        }
    }

    private static class FilterSet {
        private Function<Deployed, Key> KEY_FUNC = input -> new Key(input.getDeployable().getId(), input.getContainer().getId());
        private Function<Value, String> VALUE_KEY_FUNC = input -> ((Value)input).deployed.getId();
        private Map<Key, Map<String, Value>> map = new HashMap<Key, Map<String, Value>>();

        public FilterSet(Collection<Deployed> initialDeployeds) {
            initialDeployeds.stream().forEach(d -> {
                if (this.isProvisionable(d.getDeployable())) {
                    this.addProvisioned((Deployed)d);
                } else {
                    this.addDeployed((Deployed)d);
                }
            });
        }

        private void addDeployed(Deployed d) {
            this.putInitial((Key)this.KEY_FUNC.apply((Object)d), new Value(d));
        }

        private void addProvisioned(Deployed d) {
            Key key = (Key)this.KEY_FUNC.apply((Object)d);
            if (this.keyExists(key)) {
                this.putInExisting(key, new Value(d));
            } else {
                this.putInitial(key, new Value(d));
            }
        }

        private void putInExisting(Key key, Value v) {
            this.map.get(key).put((String)this.VALUE_KEY_FUNC.apply((Object)v), v);
        }

        private boolean keyExists(Key key) {
            return this.map.containsKey(key);
        }

        private Map<String, Value> putInitial(Key key, Value v) {
            HashMap<Object, Value> m = new HashMap<Object, Value>();
            m.put(this.VALUE_KEY_FUNC.apply((Object)v), v);
            return this.map.put(key, m);
        }

        private boolean isProvisionable(Deployable deployable) {
            return deployable instanceof BaseProvisionable;
        }

        public void add(ConfigurationItem ci) {
            Deployed deployed = (Deployed)ci;
            Key k = (Key)this.KEY_FUNC.apply((Object)deployed);
            Value v = new Value(deployed).valid();
            if (this.isProvisionable(deployed.getDeployable())) {
                this.addProvisioned(deployed, k, v);
            } else {
                this.addDeployed(deployed, k, v);
            }
        }

        private void addProvisioned(Deployed<?, ?> deployed, Key k, Value v) {
            if (this.keyExists(k)) {
                String valueKey;
                Map<String, Value> previous = this.map.get(k);
                Value previousValue = previous.put(valueKey = (String)this.VALUE_KEY_FUNC.apply((Object)v), v);
                if (previousValue != null) {
                    logger.debug("Filtering out [{}] because it is already present.", deployed);
                    previous.put(valueKey, previousValue.valid());
                }
            } else {
                this.putInitial(k, v);
            }
        }

        private void addDeployed(Deployed<?, ?> deployed, Key k, Value v) {
            Map<String, Value> previous = this.putInitial(k, v);
            if (previous != null) {
                logger.debug("Filtering out [{}] because it is already present.", deployed);
                previous = previous.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Value)e.getValue()).valid()));
                this.map.put(k, previous);
            }
        }

        public List<Deployed> getAllValidAsList() {
            return this.map.values().stream().map(m -> m.values()).flatMap(v -> v.stream()).filter(rec$ -> ((Value)rec$).isValid()).map(value -> ((Value)value).deployed).collect(Collectors.toList());
        }
    }
}

