/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.service.deployment.BasicDeployedGenerator;
import com.xebialabs.deployit.service.deployment.CardinalDeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeployedArtifactPlaceholdersResolver;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.PerDeployableTypeGenerator;
import com.xebialabs.deployit.service.deployment.PlaceholderPropertyDeployedGenerator;
import com.xebialabs.deployit.service.deployment.PropertyResolverDeployedGenerator;
import com.xebialabs.deployit.service.deployment.ProvisioningPlaceholderPropertyResolverDeployedGenerator;
import com.xebialabs.deployit.service.deployment.TagMatchingDeployedGenerator;
import com.xebialabs.deployit.service.deployment.TypeCalculator;
import com.xebialabs.deployit.service.deployment.TypeFilterDeployedGenerator;
import com.xebialabs.deployit.service.deployment.UpdateSameDeployableChainGenerator;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeployedProcessorsFactory {
    private final DeploymentContext.BeanSupplier beanSupplier;
    private final TypeCalculator calculator;
    private final Map<Type, Class<? extends DeployedGenerator>> deployableSpecificGenerators = new HashMap<Type, Class<? extends DeployedGenerator>>();

    @Autowired
    public DeployedProcessorsFactory(DeployedArtifactPlaceholdersResolver deployedArtifactPlaceholdersResolver, DeployedPropertySetter deployedPropertySetter, TypeCalculator calculator) {
        final HashMap beans = new HashMap();
        beans.put(deployedArtifactPlaceholdersResolver.getClass(), deployedArtifactPlaceholdersResolver);
        beans.put(deployedPropertySetter.getClass(), deployedPropertySetter);
        beans.put(calculator.getClass(), calculator);
        this.beanSupplier = new DeploymentContext.BeanSupplier(){

            @Override
            public <T> T getBean(Class<T> beanClass) {
                return beanClass.cast(beans.get(beanClass));
            }
        };
        this.calculator = calculator;
    }

    public DeployedGenerator createTagDeployedGenerator() {
        return new TagMatchingDeployedGenerator(this.createCoreDeployedGenerator());
    }

    public DeployedGenerator createCoreDeployedGenerator() {
        return new ProvisioningPlaceholderPropertyResolverDeployedGenerator(this.perTypeDeployedGenerator(new PlaceholderPropertyDeployedGenerator(new PropertyResolverDeployedGenerator(new TypeFilterDeployedGenerator(new CardinalDeployedGenerator(new BasicDeployedGenerator()))))));
    }

    public DeployedGenerator createUpgradeDeployedGenerator() {
        return new ProvisioningPlaceholderPropertyResolverDeployedGenerator(this.perTypeDeployedGenerator(new UpdateSameDeployableChainGenerator(new PlaceholderPropertyDeployedGenerator(new PropertyResolverDeployedGenerator(new CardinalDeployedGenerator(new BasicDeployedGenerator()))))));
    }

    private PerDeployableTypeGenerator perTypeDeployedGenerator(DeployedGenerator generator) {
        return new PerDeployableTypeGenerator(this.deployableSpecificGenerators, generator);
    }

    public DeploymentContext createContextForSpecificType(Deployment deployment, Dictionaries dictionaries, Type deployedType) {
        return new DeploymentContext((DeployedApplication)deployment.getDeployedApplication(), dictionaries, this.beanSupplier, (deployable, container) -> deployedType, deployable -> Collections.emptyList());
    }

    public DeploymentContext createContextWithCalculatedType(Deployment deployment, Dictionaries dictionaries) {
        return new DeploymentContext((DeployedApplication)deployment.getDeployedApplication(), dictionaries, this.beanSupplier, (deployable, container) -> this.calculator.findMostSpecificDeployedType(deployable.getType(), container.getType()), deployable -> Collections.emptyList());
    }

    public DeploymentContext createContextForUpgrade(DeployedApplication deployedApplication, Dictionaries dictionaries, Set<Deployed> previousDeployeds) {
        Map<String, List<Deployed>> deployedsPerDeployableId = previousDeployeds.stream().filter(x -> x.getDeployable() != null).collect(Collectors.groupingBy(deployed -> deployed.getDeployable().getName()));
        return new DeploymentContext(deployedApplication, dictionaries, this.beanSupplier, (deployable, container) -> this.calculator.findMostSpecificDeployedType(deployable.getType(), container.getType()), deployable -> (List)deployedsPerDeployableId.get(deployable.getName()));
    }
}

