package com.xebialabs.xlplatform.rest.script.endpoints

import com.xebialabs.xlplatform.rest.script.Settings
import spray.routing.{Route, RequestContext, HttpServiceActor, HttpService}

import scala.reflect.runtime.universe
import scala.reflect.api.JavaUniverse
import grizzled.slf4j.Logging
import java.lang.reflect.Method
import scala.util.Try
import akka.actor.Actor.Receive
import spray.http.StatusCodes
import akka.actor.{ActorRef, Actor, Props}
import com.xebialabs.xlplatform.rest.script.endpoints.dynamic.DynamicClassCreator

trait ScalaExtensionRoute extends HttpService with Logging {

  def settings: Settings
//
//  def oldExtensionRoutes(file: String): Seq[AuthenticatedRoute] = {
//    val mirror = universe.runtimeMirror(Thread.currentThread().getContextClassLoader)
//    val endpoints: Seq[ScalaEndpoint] = ScalaEndpoints(file)
//    debug(s"Going to register endpoints: $endpoints")
//    endpoints.map { ep =>
//      val moduleMirror = mirror.reflectModule(mirror.staticModule(ep.obj))
//      val instance: Any = moduleMirror.instance
//
//      instance.getClass.getMethod(ep.f).invoke(instance).asInstanceOf[AuthenticatedRoute]
//    }
//  }
//

  var era: Option[ActorRef] = None

  def codedExtensionRoutes(file: String): Seq[AuthenticatedRoute] = {
    if (era.isEmpty) {
      val endpoints: Seq[ScalaEndpoint] = ScalaEndpoints(file)
      debug(s"Going to register endpoints: $endpoints")
      val map: Seq[Class[_]] = endpoints.map(ep => Class.forName(ep.traitClass))
      val generatedActorClass: Class[_ <: Actor] = new DynamicClassCreator().buildClass(map)
      era = Some(actorRefFactory.actorOf(Props(generatedActorClass, endpoints.map(_.pfName))))
    }
    Seq((auth: AuthenticatedData) => (ctx: RequestContext) => era.get ! (auth, ctx))

  }

  def codedExtensionRoutes: Seq[AuthenticatedRoute] = codedExtensionRoutes(settings.XlDeploy.ServerExtension.file)

}
