package com.xebialabs.xlplatform.rest.script.endpoints.dynamic

import scala.tools.nsc._
import scala.tools.nsc.interpreter._
import grizzled.slf4j.Logging
import akka.actor.Actor
import spray.routing.HttpServiceActor

object DynamicClassCreator {
  private var id = 0
  def uniqueId = synchronized {  id += 1; "DynamicRoutingActor" + id.toString }
}

class DynamicClassCreator extends java.lang.ClassLoader(getClass.getClassLoader) with Logging {

  def buildClass(ts: Seq[Class[_]]) = {
    val id = DynamicClassCreator.uniqueId

    val classDef = new StringBuilder

    classDef.append("class ").append(id)
    classDef.append("(routeNames: Seq[String])")
    classDef.append(" extends ").append(classOf[ExtensionRouteActor].getCanonicalName)
    classDef.append("(routeNames)")
    ts.foreach(t => classDef.append(" with ").append(t.getCanonicalName))

    debug(s"Defining class [$classDef]")
    val settings = new Settings(null)
    settings.usejavacp.value = true
    val interpreter = new IMain(settings)

    interpreter.compileString(classDef.toString())

    val bytes = interpreter.classLoader.classBytes(id)

    defineClass(id, bytes, 0, bytes.length).asInstanceOf[Class[_ <: Actor]]
  }
}
