package com.xebialabs.xlplatform.rest.script.boot

import spray.servlet.WebBoot
import akka.actor._
import com.xebialabs.xlplatform.rest.script.endpoints.{Endpoints, ScriptExtensionRoute}
import spray.routing.HttpServiceBase
import com.xebialabs.xlplatform.rest.script.Settings


class ApiActor extends Actor with HttpServiceBase with ScriptExtensionRoute  {

  def actorRefFactory: ActorRefFactory = context.system

  val settings: Settings = Settings(context.system)

  override def receive: Actor.Receive = {
    runRoute(routes(Endpoints(settings.XlDeploy.ServerExtension.file)))
  }
}

class ServletBoot extends WebBoot {

  val system =  ActorSystem("extension-servlet-system")

  val serviceActor = system.actorOf(Props[ApiActor], "extension-rest-api")

}
