/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Version;

public class IdGenerator {
    public static String generateId(String container, String contained) {
        String id = container;
        id = id + "/" + IdGenerator.lastPartOfId(contained);
        return id;
    }

    private static String lastPartOfId(String id) {
        return (String)Iterables.getLast((Iterable)Splitter.on((String)"/").split((CharSequence)id));
    }

    public static String generateId(ConfigurationItem container, ConfigurationItem contained) {
        return IdGenerator.generateId(container.getId(), contained.getId());
    }

    public static String generateId(Metadata.ConfigurationItemRoot root, String id) {
        return IdGenerator.generateId(root.getRootNodeName(), id);
    }

    public static String generateId(ConfigurationItem parent, String id) {
        return IdGenerator.generateId(parent.getId(), id);
    }

    public static void generateId(Deployed deployed) {
        deployed.setId(IdGenerator.generateId((ConfigurationItem)deployed.getContainer(), (ConfigurationItem)deployed.getDeployable()));
    }

    public static void generateId(DeployedApplication deployedApplication) {
        Version version = deployedApplication.getVersion();
        deployedApplication.setId(IdGenerator.generateId(deployedApplication.getEnvironment().getId(), version.getApplication().getId()));
    }
}

