package com.xebialabs.deployit.server.api.util;

import com.google.common.base.Splitter;
import com.xebialabs.deployit.plugin.api.udm.*;

import static com.google.common.collect.Iterables.getLast;

public class IdGenerator {

    public static String generateId(String container, String contained) {
        String id = container;
        id += "/" + lastPartOfId(contained);
        return id;
    }

    private static String lastPartOfId(String id) {
        return getLast(Splitter.on("/").split(id));
    }

    public static String generateId(ConfigurationItem container, ConfigurationItem contained) {
        return generateId(container.getId(), contained.getId());
    }

	public static String generateId(Metadata.ConfigurationItemRoot root, String id) {
		return generateId(root.getRootNodeName(), id);
	}

	public static String generateId(ConfigurationItem parent, String id) {
		return generateId(parent.getId(), id);
	}

    @SuppressWarnings("rawtypes")
    public static void generateId(Deployed deployed) {
        deployed.setId(generateId(deployed.getContainer(), deployed.getDeployable()));
    }

    public static void generateId(DeployedApplication deployedApplication) {
        Version version = deployedApplication.getVersion();

        deployedApplication.setId(generateId(deployedApplication.getEnvironment().getId(), version.getApplication().getId()));
    }
}
