/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.setup.FileCopier;
import com.xebialabs.deployit.setup.SetupConfiguration;
import com.xebialabs.deployit.setup.SetupHelperMethods;
import com.xebialabs.deployit.setup.UpgradeHelper;
import com.xebialabs.deployit.util.DeployitKeyStore;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class Setup {
    private static final Logger logger = LoggerFactory.getLogger(Setup.class);
    public static final String TRUSTSTORE_PATH = "What is the path to the truststore?";
    public static final String KEYSTORE_PATH = "What is the path to the keystore?";
    public static final String JDBC_URL = "What is the JDBC URL to use?";
    public static final String JDBC_USER_NAME = "What is the JDBC username?";
    public static final String JDBC_DRIVER_NAME = "What is the JDBC driver name? ";
    private final String serverName;
    private final ServerConfigFile serverConfigFile;
    private final ServerLaunchOptions launchOptions;
    private Map<String, String> newDbConfigs;
    protected ServerConfiguration configuration;
    private final boolean askImportablePackagesPath = true;
    private final boolean askServerUrl = false;
    private boolean generateKeyStore;
    private boolean generatePasswordEncryptionKey;
    private String passwordEncryptionKeyPassword;
    public static final File DEPLOY_DEFAULTS = new File("centralConfiguration", "deploy-defaults.properties");
    private final File repositoryFile = new File(XldServerPaths.CENTRAL_CONFIG_FOLDER, "deploy-repository.yaml");

    public Setup(String serverName, ServerConfigFile serverConfigFile, ServerLaunchOptions deployitOptions) {
        this(serverName, serverConfigFile, deployitOptions, new ServerConfiguration());
    }

    public Setup(String serverName, ServerConfigFile serverConfigFile, ServerLaunchOptions deployitOptions, ServerConfiguration defaultConfiguration) {
        this.serverName = serverName;
        this.serverConfigFile = serverConfigFile;
        this.launchOptions = deployitOptions;
        this.configuration = defaultConfiguration;
    }

    public void run() {
        logger.info("About to start XL Deploy");
        LocalBooter.boot((File)DEPLOY_DEFAULTS);
        logger.info("The DescriptorRegistry has been booted");
        String previousInstallation = this.launchOptions.getPreviousInstallation();
        if (Strings.isNotBlank((String)previousInstallation)) {
            this.runUpgrade(previousInstallation);
        } else if (this.launchOptions.isReinitialize()) {
            this.reinitialize();
        } else {
            this.runComplete();
        }
    }

    private void runUpgrade(String previousInstallation) {
        if (!this.launchOptions.isDoSetup()) {
            throw new RuntimeException("Option `-previous-installation` is only supported in setup mode (with `-setup` option)");
        }
        System.out.println("\nWelcome to the " + this.serverName + " setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        UpgradeHelper upgradeHelper = new UpgradeHelper(previousInstallation, this.launchOptions.isForceUpgrades(), new FileCopier());
        SetupConfiguration config = this.readSetupConfigurationProperties();
        List<String> dirs = Collections.singletonList("ext");
        List<String> filesToMention = Collections.singletonList("xl-deploy.conf");
        upgradeHelper.copyData(config.getConfigFiles().getMandatory(), dirs, filesToMention, config.getConfigFiles().getOptional());
        this.serverConfigFile.appendConfiguration(Collections.singletonMap("xl.spring.cloud.encrypt.key", this.configuration.generateCloudKey()));
        try {
            File centralConfigFile = XldServerPaths.DEFAULT_CENTRAL_CONFIG_VERSION_FILE;
            if (!previousInstallation.isEmpty() && !centralConfigFile.exists()) {
                FileUtils.writeStringToFile((File)centralConfigFile, (String)"central.configuration.version=10.0.0", (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SetupConfiguration readSetupConfigurationProperties() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = loader.getResourceAsStream("setup.yaml");
        return (SetupConfiguration)new Yaml((BaseConstructor)new Constructor(SetupConfiguration.class)).loadAs(inputStream, SetupConfiguration.class);
    }

    private void reinitialize() {
        SecretKey passwordEncryptionKey;
        String repositoryKeystorePassword;
        if (!this.launchOptions.isForce()) {
            System.out.println("The -reinitialize will only work with a default repository setup; Not when you've configured " + this.serverName + "  to integrate with a database.");
            System.out.println("Are you sure you want to continue (yes or no)?");
            if (!SetupHelperMethods.getBooleanResponse((boolean)false)) {
                return;
            }
        }
        if (null != (repositoryKeystorePassword = this.launchOptions.getRepositoryKeystorePassword())) {
            DeployitKeyStore.generateRandomKeyStore((File)new File("conf"), (String)repositoryKeystorePassword);
            passwordEncryptionKey = DeployitKeyStore.getPasswordEncryptionKey();
        } else {
            passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeystorePassword);
        }
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        this.useDefaultValues(this.launchOptions.getDefaultsFile());
        if (this.configuration.getHttpPort() == 0) {
            this.configuration.setHttpPort(this.defaultHttpPort());
        }
        this.configuration.setSpringCloudEnabled(Boolean.valueOf(true));
        this.serverConfigFile.writeConfiguration(this.configuration);
        this.configuration = this.serverConfigFile.loadConfig();
        Setup.deleteTaskRecoveryFile();
    }

    private void runComplete() {
        SecretKey passwordEncryptionKey;
        System.out.println("\nWelcome to the " + this.serverName + " setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the " + this.serverName + " configuration you can run run.cmd -setup on Windows or run.sh -setup on Unix.");
        boolean editingExistingConfiguration = false;
        if (this.serverConfigFile.exists() && this.askDoYouWantToEditTheExistingConfiguration()) {
            passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
            this.serverConfigFile.readIntoConfiguration(this.configuration);
            editingExistingConfiguration = true;
        }
        if (Setup.askToUseSimpleSetup()) {
            if (!editingExistingConfiguration) {
                this.configuration.setHttpPort(4516);
                this.askAdminPassword();
            } else {
                this.upgradeConfigurationWithDefaultValues();
            }
            this.askToCreatePasswordEncryptionKey();
            this.askDatabaseConfiguration();
        } else {
            if (!editingExistingConfiguration) {
                this.askAdminPassword();
            }
            if (this.askToEnableSsl()) {
                if (this.askToGenerateKeys()) {
                    this.setDefaultKeyStoreSettings();
                } else {
                    this.askKeyStoreSettings();
                }
                if (this.askToEnableMutualSsl()) {
                    this.askTrustStoreSettings();
                }
            }
            this.askHttpBindAddressForJetty();
            this.askHttpPortForJetty();
            this.askWebContextRoot();
            this.askServerUrl();
            this.askMinumAmountOfThreads();
            this.askMaximumAmountOfThreads();
            this.askToCreatePasswordEncryptionKey();
            this.askDatabaseConfiguration();
            this.askImportablePackagesPath();
        }
        if (this.reviewAndConfirm()) {
            this.updateRepositoryConfig();
            if (this.generatePasswordEncryptionKey) {
                DeployitKeyStore.generateRandomKeyStore((File)new File("conf"), (String)this.passwordEncryptionKeyPassword);
                passwordEncryptionKey = DeployitKeyStore.getPasswordEncryptionKey();
            } else {
                passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)this.launchOptions.getRepositoryKeystorePassword());
            }
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
            System.out.println("Saving to " + this.serverConfigFile);
            this.configuration.setSpringCloudEnabled(Boolean.valueOf(true));
            this.serverConfigFile.writeConfiguration(this.configuration);
            System.out.println("Configuration saved.");
            if (this.generateKeyStore) {
                this.generateKeyStore();
            }
            this.configuration = this.serverConfigFile.loadConfig();
            System.out.println("You can now start your " + this.serverName + " by executing the command run.cmd on Windows or run.sh on Unix.");
            System.out.println("Note: If your " + this.serverName + " is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private void updateRepositoryConfig() {
        try {
            Map<String, Map<String, Map<String, String>>> configToDump = Collections.singletonMap("xl.repository", Collections.singletonMap("database", this.newDbConfigs));
            if (this.newDbConfigs != null && !this.newDbConfigs.isEmpty()) {
                String content = this.createYamlParser().dump(configToDump);
                Files.write(Paths.get(this.repositoryFile.getPath(), new String[0]), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void useDefaultValues(String defaultsFile) {
        block4: {
            this.configuration.setDefaults();
            if (defaultsFile == null) break block4;
            File file = new File(defaultsFile);
            OverthereUtils.checkState((boolean)file.exists(), (String)"The given file [%s] with defaults does not exist.", (Object[])new Object[]{defaultsFile});
            Properties properties = new Properties();
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(file);
                properties.load(inStream);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Cannot load [" + file + "] to read defaults from.");
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(inStream);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)inStream);
            this.configuration.load(properties);
        }
    }

    private void askAdminPassword() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Please enter the admin password you wish to use for " + this.serverName);
        String password = SetupHelperMethods.getConfirmedPassword();
        if (Strings.isEmpty((String)password)) {
            System.out.println("Using default admin password.");
            this.configuration.setAdminPassword("admin");
        } else {
            this.configuration.setAdminPassword(password);
        }
    }

    private void askWebContextRoot() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the web context root where " + this.serverName + " will run");
        Object contextRoot = SetupHelperMethods.getStringResponse((String)"/");
        if (!((String)contextRoot).startsWith("/")) {
            contextRoot = "/" + (String)contextRoot;
        }
        this.configuration.setWebContextRoot((String)contextRoot);
    }

    private void askServerUrl() {
    }

    private void upgradeConfigurationWithDefaultValues() {
        if (this.configuration.getMinThreads() == 0) {
            this.configuration.setMinThreads(30);
        }
        if (this.configuration.getMaxThreads() == 0) {
            this.configuration.setMaxThreads(150);
        }
        if (this.configuration.getImportablePackagesPath() == null) {
            this.configuration.setImportablePackagesPath("importablePackages");
        }
        if (this.configuration.getHttpPort() == 0) {
            this.configuration.setHttpPort(4516);
        }
    }

    private void askMinumAmountOfThreads() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 30 for 10 concurrent users)");
        int suppliedMinThreads = this.configuration.getMinThreads() == 0 ? 30 : this.configuration.getMinThreads();
        this.configuration.setMinThreads(SetupHelperMethods.getValidIntegerResponse((int)suppliedMinThreads));
    }

    private void askMaximumAmountOfThreads() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 150 for 50 concurrent users)");
        int suppliedMaxThreads = this.configuration.getMaxThreads() == 0 ? 150 : this.configuration.getMaxThreads();
        this.configuration.setMaxThreads(SetupHelperMethods.getValidIntegerResponse((int)suppliedMaxThreads));
    }

    private static boolean askToUseSimpleSetup() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return SetupHelperMethods.getBooleanResponse((boolean)true);
    }

    private boolean askToEnableSsl() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedSsl = this.configuration.isNewConfiguration() || this.configuration.isSsl();
        this.configuration.setSsl(SetupHelperMethods.getBooleanResponse((boolean)suppliedSsl));
        return this.configuration.isSsl();
    }

    private boolean askToGenerateKeys() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Would you like to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean suppliedGenerateKeys = this.configuration.isNewConfiguration() || this.generateKeyStore;
        this.generateKeyStore = SetupHelperMethods.getBooleanResponse((boolean)suppliedGenerateKeys);
        return this.generateKeyStore;
    }

    private void setDefaultKeyStoreSettings() {
        this.configuration.setKeyStorePath("conf/keystore.p12");
        this.configuration.setKeyStorePassword("keystoresecret");
        this.configuration.setKeyStoreKeyPassword("keystoresecret");
        this.configuration.setKeyStoreType("pkcs12");
    }

    private void askKeyStoreSettings() {
        SetupHelperMethods.printEmptyLine();
        System.out.println(KEYSTORE_PATH);
        String suppliedKeyStorePath = this.configuration.isNewConfiguration() ? "" : this.configuration.getKeyStorePath();
        this.configuration.setKeyStorePath(!StringUtils.hasText((String)suppliedKeyStorePath) ? SetupHelperMethods.getStringResponseWithRetry((String)KEYSTORE_PATH) : SetupHelperMethods.getStringResponse((String)suppliedKeyStorePath));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the type of the keystore?");
        System.out.println("Options are jks, pkcs12, or other keystore types supported on the JVM.");
        String suppliedKeyStoreType = this.configuration.isNewConfiguration() ? "jks" : this.configuration.getKeyStorePath();
        this.configuration.setKeyStoreType(SetupHelperMethods.getStringResponse((String)suppliedKeyStoreType));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        this.configuration.setKeyStorePassword(SetupHelperMethods.getPasswordResponse((String)"Password: "));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        this.configuration.setKeyStoreKeyPassword(SetupHelperMethods.getPasswordResponse((String)"Password: "));
    }

    private boolean askToEnableMutualSsl() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Would you like to enable mutual SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedMutualSsl = this.configuration.isNewConfiguration() || this.configuration.isMutualSsl();
        this.configuration.setMutualSsl(SetupHelperMethods.getBooleanResponse((boolean)suppliedMutualSsl));
        return this.configuration.isMutualSsl();
    }

    private void askTrustStoreSettings() {
        SetupHelperMethods.printEmptyLine();
        System.out.println(TRUSTSTORE_PATH);
        String suppliedTrustStorePath = this.configuration.isNewConfiguration() ? "" : this.configuration.getTrustStorePath();
        this.configuration.setTrustStorePath(!StringUtils.hasText((String)suppliedTrustStorePath) ? SetupHelperMethods.getStringResponseWithRetry((String)TRUSTSTORE_PATH) : SetupHelperMethods.getStringResponse((String)suppliedTrustStorePath));
        SetupHelperMethods.printEmptyLine();
        System.out.println("What is the password to the truststore?");
        this.configuration.setTrustStorePassword(SetupHelperMethods.getPasswordResponse((String)"Password: "));
    }

    private void askHttpBindAddressForJetty() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("What http bind address would you like the server to listen on?");
        String defaultAddress = Strings.isEmpty((String)this.configuration.getHttpBindAddress()) ? "0.0.0.0" : this.configuration.getHttpBindAddress();
        this.configuration.setHttpBindAddress(SetupHelperMethods.getStringResponse((String)defaultAddress));
    }

    private void askHttpPortForJetty() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int suppliedPort = this.configuration.getHttpPort() == 0 ? this.defaultHttpPort() : this.configuration.getHttpPort();
        this.configuration.setHttpPort(SetupHelperMethods.getValidIntegerResponse((int)suppliedPort));
    }

    private int defaultHttpPort() {
        return this.configuration.isSsl() ? 4517 : 4516;
    }

    private void askImportablePackagesPath() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Where would you like " + this.serverName + " to import packages from?");
        String suppliedApplicationImportPath = this.configuration.getImportablePackagesPath() == null ? "importablePackages" : this.configuration.getImportablePackagesPath();
        this.configuration.setImportablePackagesPath(SetupHelperMethods.getValidNotEmptyStringResponse((String)suppliedApplicationImportPath));
    }

    private boolean askDoYouWantToEditTheExistingConfiguration() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("An existing " + this.serverName + " configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean useOldConfig = SetupHelperMethods.getBooleanResponse((boolean)true);
        if (useOldConfig) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return useOldConfig;
    }

    private void askToCreatePasswordEncryptionKey() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("The password encryption key protects the passwords stored in the repository. ");
        System.out.println("Do you want to generate a new password encryption key?");
        System.out.println("Options are yes or no.");
        this.generatePasswordEncryptionKey = SetupHelperMethods.getBooleanResponse((boolean)true);
        if (this.generatePasswordEncryptionKey) {
            System.out.println("The password encryption key is optionally secured by a password.");
            System.out.println("Please enter the password you wish to use. (Use an empty password to avoid a password prompt when starting " + this.serverName + ".)");
            this.passwordEncryptionKeyPassword = SetupHelperMethods.getConfirmedPassword();
        }
    }

    private void askDatabaseConfiguration() {
        SetupHelperMethods.printEmptyLine();
        System.out.print("Do you want to configure the database connection in this wizard? ");
        if (SetupHelperMethods.getBooleanResponse((boolean)false)) {
            this.newDbConfigs = new HashMap<String, String>();
            System.out.print(JDBC_URL);
            String jdbcUrl = SetupHelperMethods.getStringResponseWithRetry((String)JDBC_URL);
            this.newDbConfigs.put("db-url", jdbcUrl);
            String driverFound = this.findJdbcDriver(jdbcUrl);
            System.out.print(JDBC_DRIVER_NAME);
            this.newDbConfigs.put("db-driver-classname", !StringUtils.hasText((String)driverFound) ? SetupHelperMethods.getStringResponseWithRetry((String)JDBC_DRIVER_NAME) : SetupHelperMethods.getStringResponse((String)driverFound));
            System.out.print(JDBC_USER_NAME);
            this.newDbConfigs.put("db-username", SetupHelperMethods.getStringResponseWithRetry((String)JDBC_USER_NAME));
            System.out.print("What is the JDBC password? ");
            this.newDbConfigs.put("db-password", SetupHelperMethods.getPasswordResponse((String)": "));
        }
    }

    private Yaml createYamlParser() {
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml(options);
    }

    private String findJdbcDriver(String jdbcUrl) {
        try {
            return DriverManager.getDriver(jdbcUrl).getClass().getName();
        }
        catch (SQLException e) {
            System.out.println("No registered JDBC driver could be found for '" + jdbcUrl + "'.");
            System.out.println("You can continue setup, but server startup will fail unless you provide the JDBC driver jar.");
            return null;
        }
    }

    private boolean reviewAndConfirm() {
        SetupHelperMethods.printEmptyLine();
        System.out.println("Do you agree with the following settings for " + this.serverName + " and would you like to save them?");
        System.out.println("Changes will be saved in " + this.serverConfigFile.getName());
        System.out.println("\tSSL will be " + (this.configuration.isSsl() ? "enabled" : "disabled"));
        if (this.configuration.isSsl()) {
            if (this.generateKeyStore) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + this.configuration.getKeyStorePath());
            }
        }
        System.out.println("\tHTTP bind address is " + this.configuration.getHttpBindAddress());
        System.out.println("\tHTTP port is " + this.configuration.getHttpPort());
        System.out.println("\tContext root is " + this.configuration.getWebContextRoot());
        System.out.println("\tHTTP server will use a minimum of " + this.configuration.getMinThreads() + " and a maximum of " + this.configuration.getMaxThreads() + " threads");
        if (this.launchOptions.isReinitialize()) {
            System.out.println("\tTask recovery file will be deleted");
        }
        if (this.generatePasswordEncryptionKey) {
            System.out.println("\tPassword encryption key will be generated.");
        }
        if (this.configuration.isSpringCloudEnabled().booleanValue() && this.configuration.getSpringCloudUri() != null) {
            System.out.println("\tConfig Server - URI: " + this.configuration.getSpringCloudUri());
            System.out.println("\tConfig Server - Name: " + this.configuration.getSpringCloudName());
            System.out.println("\tConfig Server - Profile: " + this.configuration.getSpringCloudProfile());
            System.out.println("\tConfig Server - Label: " + this.configuration.getSpringCloudLabel());
            System.out.println("\tConfig Server - Retry initial interval: " + this.configuration.getSpringCloudRetryInitialInterval());
            System.out.println("\tConfig Server - Retry max attempts: " + this.configuration.getSpringCloudRetryMaxAttempts());
            System.out.println("\tConfig Server - Retry max interval: " + this.configuration.getSpringCloudRetryMaxInterval());
            System.out.println("\tConfig Server - Retry multiplier: " + this.configuration.getSpringCloudRetryMultiplier());
            if (this.configuration.getSpringCloudGitUri() != null) {
                System.out.println("\tConfig Server Git Repository - URI: " + this.configuration.getSpringCloudGitUri());
            }
        }
        System.out.println("\tApplication import location is " + this.configuration.getImportablePackagesPath());
        if (this.newDbConfigs != null) {
            String dbUsername;
            String dbDriverClassname;
            System.out.println("\nAnd database changes to " + this.repositoryFile.getAbsolutePath());
            String dbUrl = this.newDbConfigs.get("db-url");
            if (dbUrl != null) {
                System.out.println("\tDatabase connection - URL: " + dbUrl);
            }
            if ((dbDriverClassname = this.newDbConfigs.get("db-driver-classname")) != null) {
                System.out.println("\tDatabase connection - Driver: " + dbDriverClassname);
            }
            if ((dbUsername = this.newDbConfigs.get("db-username")) != null) {
                System.out.println("\tDatabase connection - Username: " + dbUsername);
            }
        }
        return SetupHelperMethods.getBooleanResponse((boolean)true);
    }

    private void generateKeyStore() {
        String keyAlgorithm = "RSA";
        String keyStoreKeyAlias = "jetty";
        String dname = "CN=localhost,O=" + this.serverName + ",C=NL";
        try {
            int exitValue;
            File keyStoreFile = new File(this.configuration.getKeyStorePath());
            if (keyStoreFile.exists()) {
                if (!keyStoreFile.delete()) {
                    System.out.println("Existing keystore " + this.configuration.getKeyStorePath() + " has not been deleted.");
                } else {
                    System.out.println("Existing keystore " + this.configuration.getKeyStorePath() + " deleted.");
                }
            }
            System.out.println("Generating keystore...");
            String[] keytoolArgs = new String[]{"keytool", "-genkey", "-keyalg", keyAlgorithm, "-keystore", this.configuration.getKeyStorePath(), "-storepass", this.configuration.getKeyStorePassword(), "-alias", keyStoreKeyAlias, "-keypass", this.configuration.getKeyStoreKeyPassword(), "-validity", "366", "-dname", dname, "-deststoretype", "pkcs12"};
            Process p = Runtime.getRuntime().exec(keytoolArgs);
            Thread outputThread = new Thread(new InputStreamToOutputStream(p.getInputStream(), System.out));
            outputThread.start();
            Thread errorThread = new Thread(new InputStreamToOutputStream(p.getErrorStream(), System.err));
            errorThread.start();
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException exc) {
                throw new IOException(exc.toString());
            }
            if (exitValue != 0) {
                throw new IOException("keytool exited with status code " + exitValue);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not generate keystore " + this.configuration.getKeyStorePath() + ": " + exc);
        }
    }

    protected static void deleteTaskRecoveryFile() {
        File taskRecoveryFile = new File("recovery.dat");
        if (taskRecoveryFile.exists()) {
            if (taskRecoveryFile.delete()) {
                System.out.println("Task recovery file deleted");
            } else {
                System.err.println("Couldn't delete the task recovery file");
            }
        }
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public InputStreamToOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            OverthereUtils.write((InputStream)this.in, (OutputStream)this.out);
        }
    }
}

