/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins;

import com.tqdev.metrics.core.MetricRegistry;
import com.tqdev.metrics.jdbc.InstrumentedDataSource;
import com.xebialabs.deployit.core.config.SqlConfiguration$;
import com.xebialabs.deployit.core.config.db.DatabaseConfig;
import com.xebialabs.deployit.core.config.db.MainDatabase;
import com.xebialabs.deployit.core.metrics.XldDbMetricsTrackerFactory;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlDialect$;
import com.xebialabs.deployit.plumbing.CurrentVersion$;
import com.xebialabs.plugin.manager.config.PluginManagerProperties;
import com.xebialabs.plugin.manager.materializer.PluginsMaterializer;
import com.xebialabs.plugin.manager.service.LocalPluginService;
import com.xebialabs.plugin.manager.sql.SqlPluginRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.beans.BeanProperty;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ClassLoaderForLiquibase;
import liquibase.resource.ResourceAccessor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;
import scala.Function0;
import scala.None$;
import scala.Option$;
import scala.reflect.ScalaSignature;

@Configuration
@ConfigurationProperties(prefix="deploy.plugins")
@ScalaSignature(bytes="\u0006\u0005\t\u0015c\u0001B\f\u0019\u0001\u0005BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005\u0002eBQ!\u0016\u0001\u0005\u0002YCq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0005\u0002\u001e\u0001\u0001\r\u0011\"\u0001\u0002 !I\u0011\u0011\u0007\u0001A\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003\u000b\u0002\u0001\u0015)\u0003\u0002\"!9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\f\u0003O\u0002\u0001\u0019!a\u0001\n\u0003\tI\u0007C\u0006\u0002r\u0001\u0001\r\u00111A\u0005\u0002\u0005M\u0004bCA<\u0001\u0001\u0007\t\u0011)Q\u0005\u0003WB1\"!\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\b\"Y\u0011Q\u0013\u0001A\u0002\u0003\u0007I\u0011AAL\u0011-\tY\n\u0001a\u0001\u0002\u0003\u0006K!!#\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006BB;\u0001\t\u0003\tI\r\u0003\u0004\u007f\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\t\t\u000f\u0001C\u0005\u0003GDqA!\u0004\u0001\t\u0013\u0011yA\u0001\u000eQYV<\u0017N\\'b]\u0006<WM]\"p]\u001aLw-\u001e:bi&|gN\u0003\u0002\u001a5\u00059\u0001\u000f\\;hS:\u001c(BA\u000e\u001d\u0003!!W\r\u001d7ps&$(BA\u000f\u001f\u0003%AXMY5bY\u0006\u00147OC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0005\f\t\u0003G)j\u0011\u0001\n\u0006\u0003K\u0019\naaY8oM&<'BA\u0014)\u0003\u001di\u0017M\\1hKJT!!\u000b\u000f\u0002\rAdWoZ5o\u0013\tYCEA\fQYV<\u0017N\\'b]\u0006<WM\u001d)s_B,'\u000f^5fgB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\u0006g24GG\u001b\u0006\u0002c\u0005AqM]5{u2,G-\u0003\u00024]\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00017!\t9\u0004!D\u0001\u0019\u0003M\u0001H.^4j]Nl\u0015\r^3sS\u0006d\u0017N_3s)\tQ\u0004\t\u0005\u0002<}5\tAH\u0003\u0002>M\u0005aQ.\u0019;fe&\fG.\u001b>fe&\u0011q\b\u0010\u0002\u0014!2,x-\u001b8t\u001b\u0006$XM]5bY&TXM\u001d\u0005\u0006\u0003\n\u0001\rAQ\u0001\u000be\u0016\u0004xn]5u_JL\bCA\"G\u001b\u0005!%BA#'\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u000f\u0012\u00131cU9m!2,x-\u001b8SKB|7/\u001b;pefD#AA%\u0011\u0005)\u001bV\"A&\u000b\u00051k\u0015AC1o]>$\u0018\r^5p]*\u0011ajT\u0001\bG>tG/\u001a=u\u0015\t\u0001\u0016+A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0016aA8sO&\u0011Ak\u0013\u0002\u0005\u0005\u0016\fg.A\ntc2\u0004F.^4j]J+\u0007o\\:ji>\u0014\u0018\u0010F\u0002X?Z\u0004\"\u0001W/\u000e\u0003eS!AW.\u0002\u0017%tG/\u001a:dKB$xN\u001d\u0006\u00039>\u000b1\u0002\u001e:b]N\f7\r^5p]&\u0011a,\u0017\u0002\u001c)J\fgn]1di&|g\u000e\u0015:pqf4\u0015m\u0019;pef\u0014U-\u00198\t\u000b\u0001\u001c\u0001\u0019A1\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017\u0001B2pe\u0016T!AZ(\u0002\t)$'mY\u0005\u0003Q\u000e\u0014AB\u00133cGR+W\u000e\u001d7bi\u0016DCa\u00186tiB\u00111.]\u0007\u0002Y*\u0011A*\u001c\u0006\u0003]>\fqAZ1di>\u0014\u0018P\u0003\u0002q\u001f\u0006)!-Z1og&\u0011!\u000f\u001c\u0002\n#V\fG.\u001b4jKJ\fQA^1mk\u0016\f\u0013!^\u0001\u001aa2,x-\u001b8NC:\fw-\u001a:KI\n\u001cG+Z7qY\u0006$X\rC\u0003x\u0007\u0001\u0007\u00010\u0001\u0002u[B\u0011\u0011P_\u0007\u00027&\u00111p\u0017\u0002\u001b!2\fGOZ8s[R\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0005m*\u001cX0I\u0001\u007f\u0003}\u0001H.^4j]6\u000bg.Y4feR\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM\u001d\u0015\u0003\u0007%\u000b!\u0003\\8dC2\u0004F.^4j]N+'O^5dKR!\u0011QAA\t!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006M\u000591/\u001a:wS\u000e,\u0017\u0002BA\b\u0003\u0013\u0011!\u0003T8dC2\u0004F.^4j]N+'O^5dK\")\u0011\t\u0002a\u0001\u0005\"\u001aA!!\u0006\u0011\u0007)\u000b9\"C\u0002\u0002\u001a-\u0013A\u0001T1{s\"\u0012A!S\u0001\tI\u0006$\u0018MY1tKV\u0011\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\t!'MC\u0002&\u0003WQ!\u0001\u001a\u000e\n\t\u0005=\u0012Q\u0005\u0002\u000f\t\u0006$\u0018MY1tK\u000e{gNZ5h\u00031!\u0017\r^1cCN,w\fJ3r)\u0011\t)$!\u0011\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ!!a\u000f\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005}\u0012\u0011\b\u0002\u0005+:LG\u000fC\u0005\u0002D\u0019\t\t\u00111\u0001\u0002\"\u0005\u0019\u0001\u0010J\u0019\u0002\u0013\u0011\fG/\u00192bg\u0016\u0004\u0003fA\u0004\u0002JA!\u00111JA*\u001b\t\tiEC\u0002q\u0003\u001fR!!!\u0015\u0002\t)\fg/Y\u0005\u0005\u0003+\niE\u0001\u0007CK\u0006t\u0007K]8qKJ$\u00180A\u0006hKR$\u0015\r^1cCN,GCAA\u0011Q\rA\u0011QL\u0006\u0001\u0003-\u0019X\r\u001e#bi\u0006\u0014\u0017m]3\u0015\t\u0005U\u00121\r\u0005\n\u0003\u0007J\u0011\u0011!a\u0001\u0003CA3!CA/\u00031i\u0017-\u001b8ECR\f'-Y:f+\t\tY\u0007\u0005\u0003\u0002$\u00055\u0014\u0002BA8\u0003K\u0011A\"T1j]\u0012\u000bG/\u00192bg\u0016\f\u0001#\\1j]\u0012\u000bG/\u00192bg\u0016|F%Z9\u0015\t\u0005U\u0012Q\u000f\u0005\n\u0003\u0007Z\u0011\u0011!a\u0001\u0003W\nQ\"\\1j]\u0012\u000bG/\u00192bg\u0016\u0004\u0003f\u0002\u0007\u0002|\u0005\u0005\u00151\u0011\t\u0004W\u0006u\u0014bAA@Y\nI\u0011)\u001e;po&\u0014X\rZ\u0001\te\u0016\fX/\u001b:fIf\t\u0011!\u0001\u000eyY\u0012$%-T3ue&\u001c7\u000f\u0016:bG.,'OR1di>\u0014\u00180\u0006\u0002\u0002\nB!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006-\u0012aB7fiJL7m]\u0005\u0005\u0003'\u000biI\u0001\u000eYY\u0012$%-T3ue&\u001c7\u000f\u0016:bG.,'OR1di>\u0014\u00180\u0001\u0010yY\u0012$%-T3ue&\u001c7\u000f\u0016:bG.,'OR1di>\u0014\u0018p\u0018\u0013fcR!\u0011QGAM\u0011%\t\u0019EDA\u0001\u0002\u0004\tI)A\u000eyY\u0012$%-T3ue&\u001c7\u000f\u0016:bG.,'OR1di>\u0014\u0018\u0010\t\u0015\u0004\u001f\u0005m\u0014a\u00069mk\u001eLg.T1oC\u001e,'\u000fR1uCN{WO]2f+\t\t\u0019\u000b\u0005\u0003\u0002&\u00065VBAAT\u0015\r)\u0015\u0011\u0016\u0006\u0003\u0003W\u000bQA[1wCbLA!a,\u0002(\nQA)\u0019;b'>,(oY3)\rAI\u00151WA[\u00035!Wm\u001d;s_flU\r\u001e5pI\u0006\u0012\u0011qW\u0001\u0006G2|7/Z\u0001\u0014a2,x-\u001b8NC:\fw-\u001a:TG\",W.Y\u000b\u0003\u0003{\u0003B!a0\u0002D6\u0011\u0011\u0011\u0019\u0006\u0004\u000b\u0006-\u0012\u0002BAc\u0003\u0003\u0014!bU2iK6\f\u0017J\u001c4pQ\t\t\u0012*F\u0001bQ\t\u0011\u0012*F\u0001yQ\t\u0019\u0012*A\u0010j]&$\u0018.\u00197ju\u0016\u0004F.^4j]6\u000bg.Y4fe\u0012\u000bG/\u00192bg\u0016$\"!!\u000e)\u0007Q\t9\u000e\u0005\u0003\u0002Z\u0006uWBAAn\u0015\ra\u0015\u0011V\u0005\u0005\u0003?\fYNA\u0007Q_N$8i\u001c8tiJ,8\r^\u0001\u0010kB$\u0017\r^3MSF,\u0018NY1tKRA\u0011QGAs\u0003\u007f\u0014\u0019\u0001C\u0004\u0002hV\u0001\r!!;\u0002\rM\u001c\u0007.Z7b!\u0011\tY/!?\u000f\t\u00055\u0018Q\u001f\t\u0005\u0003_\fI$\u0004\u0002\u0002r*\u0019\u00111\u001f\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0011\t90!\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\tY0!@\u0003\rM#(/\u001b8h\u0015\u0011\t90!\u000f\t\u000f\t\u0005Q\u00031\u0001\u0002$\u0006QA-\u0019;b'>,(oY3\t\u000f\t\u0015Q\u00031\u0001\u0003\b\u00059A-[1mK\u000e$\b\u0003BA`\u0005\u0013IAAa\u0003\u0002B\nQ1+\u001d7ES\u0006dWm\u0019;\u0002-%t7\u000f\u001e:v[\u0016tG/\u001a3ECR\f7k\\;sG\u0016$BA!\u0005\u0003\"A!!1\u0003B\u000f\u001b\t\u0011)BC\u0002g\u0005/QA!a$\u0003\u001a)\u0019!1\u0004\u0010\u0002\u000bQ\fH-\u001a<\n\t\t}!Q\u0003\u0002\u0017\u0013:\u001cHO];nK:$X\r\u001a#bi\u0006\u001cv.\u001e:dK\"9!\u0011\u0001\fA\u0002\u0005\r\u0006f\u0002\u0001\u0003&\t]\"\u0011\b\t\u0005\u0005O\u0011\u0019$\u0004\u0002\u0003*)!!1\u0006B\u0017\u0003)\u0001(o\u001c9feRLWm\u001d\u0006\u0004\u001d\n=\"b\u0001B\u0019\u001f\u0006!!m\\8u\u0013\u0011\u0011)D!\u000b\u0003/\r{gNZ5hkJ\fG/[8o!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00029sK\u001aL\u00070\t\u0002\u0003<\u0005qA-\u001a9m_ft\u0003\u000f\\;hS:\u001c\bf\u0001\u0001\u0003@A\u0019!J!\u0011\n\u0007\t\r3JA\u0007D_:4\u0017nZ;sCRLwN\u001c")
public class PluginManagerConfiguration
extends PluginManagerProperties
implements Logging {
    @BeanProperty
    private DatabaseConfig database;
    @Autowired(required=true)
    private MainDatabase mainDatabase;
    @Autowired
    private XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginManagerConfiguration pluginManagerConfiguration = this;
        synchronized (pluginManagerConfiguration) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Bean
    public PluginsMaterializer pluginsMaterializer(SqlPluginRepository repository) {
        return new PluginsMaterializer(repository, "xl-deploy");
    }

    @Bean
    public TransactionProxyFactoryBean sqlPluginRepository(@Qualifier(value="pluginManagerJdbcTemplate") JdbcTemplate jdbcTemplate, @Qualifier(value="pluginManagerTransactionManager") PlatformTransactionManager tm) {
        SqlPluginRepository target = new SqlPluginRepository(jdbcTemplate);
        TransactionProxyFactoryBean factoryBean = new TransactionProxyFactoryBean();
        factoryBean.setTransactionManager(tm);
        factoryBean.setTarget((Object)target);
        factoryBean.setProxyTargetClass(true);
        Properties txProperties = new Properties();
        txProperties.setProperty("*", "PROPAGATION_REQUIRED,ISOLATION_READ_COMMITTED");
        factoryBean.setTransactionAttributes(txProperties);
        return factoryBean;
    }

    @Bean
    @Lazy
    public LocalPluginService localPluginService(SqlPluginRepository repository) {
        return new LocalPluginService((PluginManagerProperties)this, "xl-deploy", CurrentVersion$.MODULE$.get(), repository);
    }

    public DatabaseConfig database() {
        return this.database;
    }

    public void database_$eq(DatabaseConfig x$1) {
        this.database = x$1;
    }

    public MainDatabase mainDatabase() {
        return this.mainDatabase;
    }

    public void mainDatabase_$eq(MainDatabase x$1) {
        this.mainDatabase = x$1;
    }

    public XldDbMetricsTrackerFactory xldDbMetricsTrackerFactory() {
        return this.xldDbMetricsTrackerFactory;
    }

    public void xldDbMetricsTrackerFactory_$eq(XldDbMetricsTrackerFactory x$1) {
        this.xldDbMetricsTrackerFactory = x$1;
    }

    @Bean(destroyMethod="close")
    public DataSource pluginManagerDataSource() {
        DatabaseConfig database = this.database().hasConfigured() ? this.database() : this.mainDatabase().database();
        return this.instrumentedDataSource((DataSource)SqlConfiguration$.MODULE$.hikariDataSource(database, "PluginManagerPool", this.xldDbMetricsTrackerFactory()));
    }

    @Bean
    public SchemaInfo pluginManagerSchema() {
        SqlDialect dialect = SqlDialect$.MODULE$.initializeDialect(this.pluginManagerDataSource());
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(42).append("Detected SQL dialect for plugin manager: ").append(dialect).append(".").toString());
        return new SchemaInfo(dialect, Option$.MODULE$.apply((Object)this.database().dbSchemaName()).orElse((Function0 & Serializable)() -> None$.MODULE$));
    }

    @Bean
    public JdbcTemplate pluginManagerJdbcTemplate() {
        return new JdbcTemplate(this.pluginManagerDataSource(), true);
    }

    @Bean
    public PlatformTransactionManager pluginManagerTransactionManager() {
        return new DataSourceTransactionManager(this.pluginManagerDataSource());
    }

    @PostConstruct
    public void initializePluginManagerDatabase() {
        this.updateLiquibase("com/xebialabs/plugin/manager/db/db.changelog-plugin-manager.yaml", this.pluginManagerDataSource(), this.pluginManagerSchema().sqlDialect());
    }

    private void updateLiquibase(String schema, DataSource dataSource, SqlDialect dialect) {
        try (Connection connection = dataSource.getConnection();){
            String context = SqlConfiguration$.MODULE$.liquibaseContext(dialect, connection);
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(28).append("Detected liquibase context: ").append(context).toString());
            new Liquibase(schema, (ResourceAccessor)new ClassLoaderForLiquibase(), (DatabaseConnection)new JdbcConnection(connection)).update(context);
        }
    }

    private InstrumentedDataSource instrumentedDataSource(DataSource dataSource) {
        return new InstrumentedDataSource(dataSource, MetricRegistry.getInstance());
    }

    public DatabaseConfig getDatabase() {
        return this.database();
    }

    public void setDatabase(DatabaseConfig x$1) {
        this.database_$eq(x$1);
    }

    public PluginManagerConfiguration() {
        Logging.$init$((Logging)this);
        this.database = new DatabaseConfig();
    }
}

