package com.xebialabs.deployit

import java.io.{IOException, Writer}

import jakarta.servlet.http.HttpServletResponse.{SC_FORBIDDEN, SC_NOT_FOUND}
import jakarta.servlet.http.{HttpServletRequest, HttpServletResponse}
import org.joda.time.LocalDate

class RootPageMissingErrorHandler(val welcomePage: String) extends HttpErrorHandler
{
  private def indexPage = Option(welcomePage).getOrElse("/index.html")

  override def canHandle(request: HttpServletRequest, code: Int): Boolean = // directory browsing is switched off, so request for "/" will result in FORBIDDEN (403)
    (code == SC_FORBIDDEN || code == SC_NOT_FOUND) && "" == request.getServletPath ||
    // previous version would respond to "/index.html" with Flex UI as well, now that could result in NOT_FOUND (404)
    // also respond to configurable welcome page.
    code == SC_NOT_FOUND && indexPage == request.getServletPath

  override def changeResponse(response: HttpServletResponse): Unit = response.setStatus(200)

  @throws[IOException]
  override def writeErrorContent(writer: Writer): Unit = StaticPageHelper.writeStaticPage(writer,
    "root-page-missing.html",
    "copyrightYear" -> new LocalDate().getYear.asInstanceOf[Object],
    "welcomePage" -> welcomePage
  )
}
