package com.xebialabs.deployit;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CSPFilter implements Filter {

    private static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    public static final String POLICY_DIRECTIVES_PARAM = "policyDirectives";
    private String cspHeaderValue;

    @Override
    public void init(final FilterConfig filterConfig) {
        cspHeaderValue = filterConfig.getInitParameter(POLICY_DIRECTIVES_PARAM);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse) response).setHeader(CONTENT_SECURITY_POLICY, cspHeaderValue);
        chain.doFilter(request, response);
    }
}
