package com.xebialabs.deployit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class NoCacheFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(NoCacheFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        logger.trace("Added NoCacheFilter to the mix.");
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setDateHeader("Expires", 0);
        chain.doFilter(request, httpResponse);
    }

    @Override
    public void destroy() {
        // Empty
    }
}
