package com.xebialabs.deployit.util;

import java.security.*;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;

public class CustomForkJoinWorkerThreadFactory  implements ForkJoinPool.ForkJoinWorkerThreadFactory {

    static class CustomForkJoinWorkerThread extends ForkJoinWorkerThread {

        /**
         * Creates a ForkJoinWorkerThread operating in the given pool.
         *
         * @param pool the pool this thread works in
         * @throws NullPointerException if pool is null
         */
        protected CustomForkJoinWorkerThread(final ForkJoinPool pool, ClassLoader ccl) {
            super(pool);
            super.setContextClassLoader(ccl);
        }
    }

    static AccessControlContext contextWithPermissions(Permission... perms) {
        Permissions permissions = new Permissions();
        for (Permission perm : perms)
            permissions.add(perm);
        return new AccessControlContext(
                new ProtectionDomain[] { new ProtectionDomain(null, permissions) });
    }

    private static final AccessControlContext ACC = contextWithPermissions(
            new AllPermission()
    );

    public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        return AccessController.doPrivileged(
                (PrivilegedAction<ForkJoinWorkerThread>) () -> new CustomForkJoinWorkerThread(
                        pool, ClassLoader.getSystemClassLoader()),
                ACC);
    }
}
