package com.xebialabs.deployit

import com.samskivert.mustache.Mustache

import java.io.{IOException, InputStreamReader, Writer}
import java.nio.charset.StandardCharsets
import scala.jdk.CollectionConverters._

object StaticPageHelper {
  @throws[IOException]
  def writeStaticPage(writer: Writer, resourceName: String, mustacheContext: (String, Object)*): Unit = {
    def resource = StaticPageHelper.getClass.getResourceAsStream(resourceName)

    def compiler = Mustache.compiler().emptyStringIsFalse(true).defaultValue("")

    def template = compiler.compile(new InputStreamReader(resource, StandardCharsets.UTF_8))

    template.execute(mustacheContext.toMap.asJava, writer)
  }
}
