package com.xebialabs.deployit.plugins

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.booter.local.PluginVersions
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.plugin.manager.startup.PluginUpgrader
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

@Component
class DeployitRepeatingPluginUpgrader(pluginUpgrader: PluginUpgrader) extends Upgrade with Logging{

  override def doUpgrade(): Boolean = {
    val is2425 = PluginVersions.getVersionFor("xl-plugin-manager").matches("2[4-5]\\..*") // all minor releases of 24 and 25
    val msg = if (is2425) "Upgrading DB plugins and verifying remaining (non-upgraded) plugins for JDK17 compatibility" else "Upgrading DB plugins"
    logger.info(msg)
    val allCompatible = pluginUpgrader.upgradePlugins(is2425 && ServerConfiguration.getInstance().isPluginJdkCompatibilityCheckOnProductUpgrade)
    if (!allCompatible) {
      logger.warn("Plugins incompatible with JDK17 detected, system shutting down.")
    }
    allCompatible
  }

  override def upgradeVersion(): Version = Version.valueOf("deployit", PluginVersions.getVersionFor("deployit"))
}
