/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;

public class AcceptHeaderConditionalFilter
implements Filter {
    private final Filter delegate;
    private final String acceptHeaderValue;

    public AcceptHeaderConditionalFilter(Filter delegate, String acceptHeaderValue) {
        this.delegate = delegate;
        this.acceptHeaderValue = acceptHeaderValue;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegate.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasAcceptHeaderValue((HttpServletRequest)request)) {
            this.delegate.doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean hasAcceptHeaderValue(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("Accept");
        while (headers.hasMoreElements()) {
            if (!((String)headers.nextElement()).startsWith(this.acceptHeaderValue)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        this.delegate.destroy();
    }
}

