package com.xebialabs.deployit.util

import com.xebialabs.deployit.ServerConfiguration
import org.eclipse.jetty.util.ssl.SslContextFactory

object SslFactoryBuilder {
  def build(configuration: ServerConfiguration): SslContextFactory.Server = {
    val contextFactory = new SslContextFactory.Server
    contextFactory.setKeyStorePath(configuration.getKeyStorePath)
    contextFactory.setKeyStorePassword(configuration.getKeyStorePassword)
    contextFactory.setKeyManagerPassword(configuration.getKeyStoreKeyPassword)
    Option(configuration.getKeyStoreType).foreach(contextFactory.setKeyStoreType)
    Option(configuration.getSslProtocol).map(_.trim).filter(_.nonEmpty).foreach(contextFactory.setProtocol)
    contextFactory
  }
}
