package com.xebialabs.deployit;

import com.xebialabs.deployit.core.rest.resteasy.TemporaryFiles;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.repository.NodeReaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class ClosingExceptionMapper<E extends Exception> implements ExceptionMapper<E> {
	@Override
	public final Response toResponse(E exception) {
		try {
			return handleException(exception);
		} finally {
			logger.info("Closing JcrSession if needed.");
			if (JcrTemplateHolder.get().isLoggedIn()) {
				JcrTemplateHolder.get().logout();
				NodeReaderContext.get().release();
			}
			TemporaryFiles.clear();
		}
	}

	protected abstract Response handleException(E exception);

	private static final Logger logger = LoggerFactory.getLogger(ClosingExceptionMapper.class);
}
