package com.xebialabs.deployit;

import org.owasp.validator.html.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;

public class Sanitizer {

	private static final AtomicReference<Policy> policyReference = new AtomicReference<Policy>();

	public static String sanitize(String input) {
		if (policyReference.get() == null) {
			init();
		}
		Policy policy = policyReference.get();
		AntiSamy antiSamy = new AntiSamy(policy);
		try {
			CleanResults scan = antiSamy.scan(input);
			if (!scan.getErrorMessages().isEmpty()) {
				logger.warn("Found errors during sanitation: {}", scan.getErrorMessages());
			}
			return scan.getCleanHTML();
		} catch (ScanException e) {
			throw new RuntimeException(e);
		} catch (PolicyException e) {
			throw new RuntimeException(e);
		}
	}

	private static void init() {
		InputStream resourceAsStream = Sanitizer.class.getResourceAsStream("/antisamy-slashdot-1.4.4.xml");
		try {
			Policy instance = Policy.getInstance(resourceAsStream);
			policyReference.compareAndSet(null, instance);
		} catch (PolicyException e) {
			throw new RuntimeException(e);
		}
	}

	private static final Logger logger = LoggerFactory.getLogger(Sanitizer.class);
}
