/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.setup;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.xebialabs.deployit.DeployitConfig;
import com.xebialabs.deployit.DeployitConfiguration;
import com.xebialabs.deployit.DeployitOptions;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.jcr.JackrabbitRepositoryFactoryBean;
import com.xebialabs.deployit.setup.SetupContext;
import com.xebialabs.deployit.util.DeployitKeyStore;
import com.xebialabs.deployit.util.GuavaFiles;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class Setup {
    private static final String EXITSETUP_KEYWORD = "exitsetup";

    public static void setup(DeployitOptions deployitOptions) {
        Setup setup = new Setup();
        if (deployitOptions.isReinitialize()) {
            setup.reinitialize(deployitOptions);
        } else {
            setup.run(deployitOptions);
        }
    }

    private void reinitialize(DeployitOptions deployitOptions) {
        if (!deployitOptions.isForce()) {
            System.out.println("The -reinitialize will only work with a default repository setup; Not when you've configured Deployit to integrate with a database.");
            System.out.println("Are you sure you want to continue (yes or no)?");
            if (!this.getBooleanResponse(false)) {
                return;
            }
        }
        SetupContext context = new SetupContext();
        DeployitKeyStore.load((char[])Strings.nullToEmpty((String)deployitOptions.getRepositoryKeystorePassword()).toCharArray());
        PasswordEncrypter.init((SecretKey)DeployitKeyStore.getPasswordEncryptionKey());
        this.useDefaultValues(context, deployitOptions.getDefaultsFile());
        DeployitConfiguration.writeConfiguration((DeployitConfig)context);
        DeployitConfiguration.load();
        this.initializeJcrRepository(context);
        this.deleteTaskRecoveryFile();
    }

    private void run(DeployitOptions deployitOptions) {
        System.out.println("\nWelcome to the Deployit setup.");
        System.out.println("You can always exit by typing 'exitsetup'.");
        System.out.println("To re-run this setup and make changes to the Deployit server configuration you can run server.cmd -setup on Windows or server.sh -setup on Unix.");
        SetupContext context = new SetupContext();
        boolean editingExistingConfiguration = false;
        if (DeployitConfiguration.exists() && this.askDoYouWantToEditTheExistingConfiguration(context)) {
            DeployitKeyStore.load((char[])Strings.nullToEmpty((String)deployitOptions.getRepositoryKeystorePassword()).toCharArray());
            PasswordEncrypter.init((SecretKey)DeployitKeyStore.getPasswordEncryptionKey());
            DeployitConfiguration.readIntoConfiguration((DeployitConfig)context);
            editingExistingConfiguration = true;
        }
        if (this.askDoYouWantToUseTheSimpleSetup()) {
            if (!editingExistingConfiguration) {
                this.setDefaults(context);
            } else {
                this.upgradeConfigurationWithDefaultValues(context);
            }
            this.askToInitializeJcr(context);
        } else {
            if (this.askToEnableSsl(context)) {
                if (this.askToGenerateKeys(context)) {
                    this.setDefaultKeyStoreSettings(context);
                } else {
                    this.askKeyStoreSettings(context);
                }
            }
            this.askHttpBindAddressForJetty(context);
            this.askHttpPortForJetty(context);
            this.askWebContextRoot(context);
            this.askMinumAmountOfThreads(context);
            this.askMaximumAmountOfThreads(context);
            this.askJcrRepositoryPath(context);
            this.askToInitializeJcr(context);
            this.askImprotablePackagesPath(context);
        }
        if (this.reviewAndConfirm(context)) {
            if (context.isGeneratePasswordEncryptionKey()) {
                DeployitKeyStore.generateRandomKeyStore((File)new File("conf"), (String)context.getPasswordEncryptionKeyPassword());
            } else {
                DeployitKeyStore.load((char[])Strings.nullToEmpty((String)deployitOptions.getRepositoryKeystorePassword()).toCharArray());
            }
            PasswordEncrypter.init((SecretKey)DeployitKeyStore.getPasswordEncryptionKey());
            System.out.println("Saving to " + DeployitConfiguration.DEFAULT_CONFIGURATION_FILE);
            DeployitConfiguration.writeConfiguration((DeployitConfig)context);
            System.out.println("Configuration saved.");
            if (context.isGenerateKeyStore()) {
                this.generateKeyStore(context);
            }
            DeployitConfiguration.load();
            if (context.isInitializeJcrRepository()) {
                this.initializeJcrRepository(context);
            }
            System.out.println("You can now start your Deployit server by executing the command server.cmd on Windows or server.sh on Unix.");
            System.out.println("Note: If your Deployit server is running please restart it.");
            System.out.println("Finished setup.");
        } else {
            System.out.println("Aborting setup.");
        }
    }

    private void askWebContextRoot(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the web context root where Deployit will run");
        String contextRoot = this.getStringResponse("/");
        if (!contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        context.setWebContextRoot(contextRoot);
    }

    private void upgradeConfigurationWithDefaultValues(SetupContext context) {
        if (context.getMinThreads() == 0) {
            context.setMinThreads(3);
        }
        if (context.getMaxThreads() == 0) {
            context.setMaxThreads(24);
        }
        if (context.getImportablePackagesPath() == null) {
            context.setImportablePackagesPath("importablePackages");
        }
    }

    private void askMinumAmountOfThreads(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the minimum number of threads the HTTP server should use (recommended: 3 per client, so 3 for single user usage)");
        int minThreads = 3;
        int suppliedMinThreads = context.getMinThreads() == 0 ? minThreads : context.getMinThreads();
        context.setMinThreads(this.getValidIntegerResponse(suppliedMinThreads));
    }

    private void askMaximumAmountOfThreads(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Enter the maximum number of threads the HTTP server should use (recommended :3 per client, so 24 for 8 concurrent users)");
        int maxThreads = 24;
        int suppliedMaxThreads = context.getMaxThreads() == 0 ? maxThreads : context.getMaxThreads();
        context.setMaxThreads(this.getValidIntegerResponse(suppliedMaxThreads));
    }

    private void useDefaultValues(SetupContext context, String defaultsFile) {
        this.setDefaults(context);
        if (defaultsFile != null) {
            File file = new File(defaultsFile);
            Preconditions.checkState((boolean)file.exists(), (String)"The given file [%s] with defaults does not exist.", (Object[])new Object[]{defaultsFile});
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load [" + file + "] to read defaults from.");
            }
            context.load(properties);
        }
    }

    private void setDefaults(SetupContext context) {
        context.setJcrRepositoryPath("repository");
        context.setHttpBindAddress("0.0.0.0");
        context.setHttpPort(4516);
        context.setImportablePackagesPath("importablePackages");
        context.setMinThreads(3);
        context.setMaxThreads(24);
        context.setAdminPassword("admin");
    }

    private boolean askDoYouWantToUseTheSimpleSetup() {
        this.printEmptyLine();
        System.out.println("Do you want to use the simple setup?");
        System.out.println("Default values are used for all properties. To make changes to the default properties, please answer no.");
        System.out.println("Options are yes or no.");
        return this.getBooleanResponse(true);
    }

    private boolean askToEnableSsl(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like to enable SSL?");
        System.out.println("Options are yes or no.");
        boolean suppliedSsl = context.isNewConfiguration() || context.isSsl();
        context.setSsl(this.getBooleanResponse(suppliedSsl));
        return context.isSsl();
    }

    private boolean askToGenerateKeys(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Would you like Deployit to generate a keystore with a self-signed certificate for you?");
        System.out.println("N.B.: Self-signed certificates do not work correctly with some versions of the Flash Player and some browsers!");
        System.out.println("Options are yes or no.");
        boolean suppliedGenerateKeys = context.isNewConfiguration() || context.isGenerateKeyStore();
        context.setGenerateKeyStore(this.getBooleanResponse(suppliedGenerateKeys));
        return context.isGenerateKeyStore();
    }

    private void setDefaultKeyStoreSettings(SetupContext context) {
        context.setKeyStorePath("conf/keystore.jks");
        context.setKeyStorePassword("storesecret");
        context.setKeyStoreKeyPassword("keysecret");
    }

    private void askKeyStoreSettings(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What is the path to the keystore?");
        String suppliedKeyStorePath = context.isNewConfiguration() ? "" : context.getKeyStorePath();
        context.setKeyStorePath(this.getStringResponse(suppliedKeyStorePath));
        this.printEmptyLine();
        System.out.println("What is the password to the keystore?");
        String suppliedKeyStorePassword = context.isNewConfiguration() ? "" : context.getKeyStorePassword();
        context.setKeyStorePassword(this.getStringResponse(suppliedKeyStorePassword));
        this.printEmptyLine();
        System.out.println("What is the password to the key in the keystore?");
        String suppliedKeyStoreKeyPassword = context.isNewConfiguration() ? "" : context.getKeyStoreKeyPassword();
        context.setKeyStoreKeyPassword(this.getStringResponse(suppliedKeyStoreKeyPassword));
    }

    private void askHttpBindAddressForJetty(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What http bind address would you like the server to listen on?");
        String defaultAddress = Strings.nullToEmpty((String)context.getHttpBindAddress()).isEmpty() ? "0.0.0.0" : context.getHttpBindAddress();
        context.setHttpBindAddress(this.getStringResponse(defaultAddress));
    }

    private void askHttpPortForJetty(SetupContext context) {
        this.printEmptyLine();
        System.out.println("What http port number would you like the server to listen on?");
        int defaultPort = context.isSsl() ? 4517 : 4516;
        int suppliedPort = context.getHttpPort() == 0 ? defaultPort : context.getHttpPort();
        context.setHttpPort(this.getValidIntegerResponse(suppliedPort));
    }

    private void askImprotablePackagesPath(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to import packages from?");
        String suppliedApplicationImportPath = context.getImportablePackagesPath() == null ? "importablePackages" : context.getImportablePackagesPath();
        context.setImportablePackagesPath(this.getValidNotEmptyStringResponse(suppliedApplicationImportPath));
    }

    private boolean askDoYouWantToEditTheExistingConfiguration(SetupContext context) {
        this.printEmptyLine();
        System.out.println("An existing configuration was found. Do you want to edit it?");
        System.out.println("Options are yes or no. (selecting no will create an empty configuration)");
        boolean useOldConfig = this.getBooleanResponse(true);
        if (useOldConfig) {
            System.out.println("Editing the exisiting configuration.");
        } else {
            System.out.println("Starting configuration from scratch.");
        }
        return useOldConfig;
    }

    private void askJcrRepositoryPath(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Where would you like Deployit to store the JCR repository?");
        String path = context.getJcrRepositoryPath() == null ? "repository" : context.getJcrRepositoryPath();
        String userEnteredRepoPath = this.getValidNotEmptyStringResponse(path);
        context.setJcrRepositoryPath(this.convertAbsolutePathToFileUrlIfNeeded(userEnteredRepoPath));
    }

    private String convertAbsolutePathToFileUrlIfNeeded(String path) {
        if (path.startsWith("/") || path.length() >= 3 && path.charAt(1) == ':' && path.charAt(2) == '\\') {
            return "file://" + path;
        }
        return path;
    }

    private boolean askToInitializeJcr(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Do you want Deployit to initialize the JCR repository?");
        System.out.println("Options are yes or no.");
        if (context.isNewConfiguration()) {
            context.setInitializeJcrRepository(this.getBooleanResponse(true));
        } else {
            context.setInitializeJcrRepository(this.getBooleanResponse(false));
        }
        if (context.isInitializeJcrRepository()) {
            System.out.println("Deployit will initialize the JCR repository.");
            this.askToCreatePasswordEncryptionKey(context);
        } else {
            System.out.println("Deployit will NOT initialize the JCR repository.");
        }
        return context.isInitializeJcrRepository();
    }

    private boolean askToCreatePasswordEncryptionKey(SetupContext context) {
        this.printEmptyLine();
        System.out.println("The password encryption key protects the passwords stored in the repository. ");
        System.out.println("Do you want to generate a new password encryption key?");
        System.out.println("Options are yes or no.");
        boolean createNew = this.getBooleanResponse(true);
        context.setGeneratePasswordEncryptionKey(createNew);
        if (createNew) {
            System.out.println("The password encryption key is optionally secured by a password.");
            System.out.println("Please enter the password you wish to use. (Use an empty password to avoid a password prompt when starting Deployit.)");
            String password = this.getConfirmedPassword();
            context.setPasswordEncryptionKeyPassword(password);
        }
        return createNew;
    }

    private boolean reviewAndConfirm(SetupContext context) {
        this.printEmptyLine();
        System.out.println("Do you agree with the following settings for Deployit and would you like to save them?");
        System.out.println("Changes will be saved in deployit.conf");
        System.out.println("\tSSL will be " + (context.isSsl() ? "enabled" : "disabled"));
        if (context.isSsl()) {
            if (context.isGenerateKeyStore()) {
                System.out.println("\tKeystore will be generated");
            } else {
                System.out.println("\tKeystore path is " + context.getKeyStorePath());
                System.out.println("\tKeystore password is " + context.getKeyStorePassword());
                System.out.println("\tKeystore key password is " + context.getKeyStoreKeyPassword());
            }
        }
        System.out.println("\tHTTP bind address is " + context.getHttpBindAddress());
        System.out.println("\tHTTP port is " + context.getHttpPort());
        System.out.println("\tContext root is " + context.getWebContextRoot());
        System.out.println("\tHTTP server will use a minimum of " + context.getMinThreads() + " and a maximum of " + context.getMaxThreads() + " threads");
        try {
            System.out.println("\tJCR repository home is at " + this.resolveRepositoryHome(context).getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (context.isInitializeJcrRepository()) {
            System.out.println("\tJCR repository will be initialized.");
            System.out.println("\tTask recovery file will be deleted");
        }
        if (context.isGeneratePasswordEncryptionKey()) {
            System.out.println("\tPassword encryption key will be generated.");
        }
        System.out.println("\tApplication import location is " + context.getImportablePackagesPath());
        return this.getBooleanResponse(true);
    }

    private void generateKeyStore(SetupContext context) {
        String keyAlgorithm = "RSA";
        String keyStoreKeyAlias = "jetty";
        String dname = "CN=localhost,O=Deployit,C=NL";
        try {
            int exitValue;
            File keyStoreFile = new File(context.getKeyStorePath());
            if (keyStoreFile.exists()) {
                System.out.println("Existing keystore " + context.getKeyStorePath() + " deleted.");
                keyStoreFile.delete();
            }
            System.out.println("Generating keystore...");
            String[] keytoolArgs = new String[]{"keytool", "-genkey", "-keyalg", keyAlgorithm, "-keystore", context.getKeyStorePath(), "-storepass", context.getKeyStorePassword(), "-alias", keyStoreKeyAlias, "-keypass", context.getKeyStoreKeyPassword(), "-validity", "366", "-dname", dname};
            Process p = Runtime.getRuntime().exec(keytoolArgs);
            Thread outputThread = new Thread(new InputStreamToOutputStream(p.getInputStream(), System.out));
            outputThread.start();
            Thread errorThread = new Thread(new InputStreamToOutputStream(p.getErrorStream(), System.err));
            errorThread.start();
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException exc) {
                throw new IOException(exc.toString());
            }
            if (exitValue != 0) {
                throw new IOException("keytool exited with status code " + exitValue);
            }
            System.out.println("Keystore generated.");
        }
        catch (IOException exc) {
            System.err.println("WARNING: Could not generate keystore " + context.getKeyStorePath() + ": " + exc.toString());
        }
    }

    private void initializeJcrRepository(SetupContext context) {
        Resource homeDirResource = this.resolveRepositoryHome(context);
        this.cleanUpAndReinitializeRepositoryHome(homeDirResource);
        JackrabbitRepositoryFactoryBean repositoryFactoryBean = new JackrabbitRepositoryFactoryBean();
        repositoryFactoryBean.setConfiguration((Resource)new ClassPathResource("jackrabbit-repository.xml"));
        repositoryFactoryBean.setHomeDir(homeDirResource);
        repositoryFactoryBean.setAutoInitialize(true);
        try {
            repositoryFactoryBean.afterPropertiesSet();
        }
        catch (Exception exc) {
            throw new RuntimeException("Cannot initialize JCR repository", exc);
        }
        repositoryFactoryBean.destroy();
        System.out.println("JCR repository initialized.");
        this.deleteTaskRecoveryFile();
    }

    private Resource resolveRepositoryHome(SetupContext context) {
        FileSystemResource homeDirResource;
        if (context.getJcrRepositoryPath().startsWith("file://")) {
            try {
                homeDirResource = new UrlResource(context.getJcrRepositoryPath());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("JCR Repository path is a malformed url. " + context.getJcrRepositoryPath());
            }
        } else {
            homeDirResource = new FileSystemResource(context.getJcrRepositoryPath());
        }
        return homeDirResource;
    }

    private void cleanUpAndReinitializeRepositoryHome(Resource repoHomeResource) {
        File repositoryHome = null;
        try {
            repositoryHome = repoHomeResource.getFile();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Problem resolving absolute path to JCR repository at " + repoHomeResource.getFilename(), (Throwable)e);
        }
        if (repositoryHome.exists()) {
            System.out.println("Deleting JCR repository at " + repositoryHome);
            try {
                GuavaFiles.deleteRecursively((File)repositoryHome);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot delete JCR repository at " + repositoryHome, (Throwable)exc);
            }
        }
        System.out.println("Creating JCR repository at " + repositoryHome);
        boolean created = repositoryHome.mkdirs();
        if (!created) {
            throw new RuntimeIOException("Unknown error occured while creating JCR repository at " + repoHomeResource);
        }
    }

    private void deleteTaskRecoveryFile() {
        File taskRecoveryFile = new File("recovery.dat");
        if (taskRecoveryFile.exists()) {
            if (taskRecoveryFile.delete()) {
                System.out.println("Task recovery file deleted");
            } else {
                System.err.println("Couldn't delete the task recovery file");
            }
        }
    }

    private void printEmptyLine() {
        System.out.println("");
    }

    private String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                String value = line.trim();
                if (EXITSETUP_KEYWORD.equals(value)) {
                    System.out.println("Exiting setup.");
                    System.exit(1);
                }
                return value;
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean getBooleanResponse(boolean defaultValue) {
        String prompt = this.determinePrompt(defaultValue ? "yes" : "no");
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if ("".equals(value)) {
                return defaultValue;
            }
            if ("yes".equalsIgnoreCase(value)) {
                return true;
            }
            if ("no".equalsIgnoreCase(value)) {
                return false;
            }
            System.out.println("Illegal value specified, type yes or no.");
        }
    }

    private String getValidNotEmptyStringResponse(String defaultValue) {
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if ("".equals(value) && defaultValue != null) {
                value = defaultValue;
            }
            if (!"".equals(value) && value != null) {
                return value;
            }
            System.out.println("Value cannot be empty.");
        }
    }

    private String getStringResponse(String defaultValue) {
        String value;
        String prompt = this.determinePrompt(defaultValue);
        do {
            System.out.print(prompt);
            value = this.read();
            if (!"".equals(value)) continue;
            value = defaultValue;
        } while (value == null);
        return value;
    }

    private String getConfirmedPassword() {
        String password = null;
        while (true) {
            if (!(password = this.getPasswordResponse("New password: ")).isEmpty() && password.length() < 6) {
                System.err.println("Password is shorter than 6 characters, please try again.\n");
                continue;
            }
            String retypedPassword = this.getPasswordResponse("Re-type password: ");
            if (password.equals(retypedPassword)) {
                return password;
            }
            this.printEmptyLine();
            System.err.println("The passwords do not match. Please try again.");
        }
    }

    private String getPasswordResponse(String prompt) {
        char[] password = System.console().readPassword(prompt, new Object[0]);
        return new String(password);
    }

    private int getValidIntegerResponse(int defaultValueAsAnInt) {
        String defaultValue = Integer.toString(defaultValueAsAnInt);
        String prompt = this.determinePrompt(defaultValue);
        while (true) {
            System.out.print(prompt);
            String value = this.read();
            if ("".equals(value)) {
                value = defaultValue;
            }
            try {
                int returnedValue = Integer.parseInt(value);
                if (returnedValue > 0) {
                    return returnedValue;
                }
                System.out.println("Illegal value specified. Number must be larger then 0.");
                continue;
            }
            catch (NumberFormatException nfe) {
                System.out.println("Illegal value specified. Must be a number.");
                continue;
            }
            break;
        }
    }

    private String determinePrompt(String defaultValue) {
        String prompt = defaultValue != null ? "[" + defaultValue + "]: " : ": ";
        return prompt;
    }

    private static class InputStreamToOutputStream
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public InputStreamToOutputStream(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                ByteStreams.copy((InputStream)this.in, (OutputStream)this.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

