/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.google.common.base.Strings;
import com.xebialabs.deployit.AccessLogFilter;
import com.xebialabs.deployit.CustomErrorHandler;
import com.xebialabs.deployit.FlexLicenseValidationFilter;
import com.xebialabs.deployit.HttpErrorHandler;
import com.xebialabs.deployit.NoCacheFilter;
import com.xebialabs.deployit.RootPageForwardFilter;
import com.xebialabs.deployit.RootPageMissingErrorHandler;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.ServerLaunchOptions;
import com.xebialabs.deployit.ServerState;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.core.rest.resteasy.Mime4jStorageProvider;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.hotstandby.HotStandbyActorSystem;
import com.xebialabs.deployit.jetty.ClassPathResourceContentServlet;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.jetty.MaintenanceModeFilter;
import com.xebialabs.deployit.jetty.NoOptionsFilter;
import com.xebialabs.deployit.jetty.RequestHeadersEncodedAsParametersFilter;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.LicenseRegistrationServlet;
import com.xebialabs.xlplatform.endpoints.servlet.AkkaStreamServletInitializer;
import com.xebialabs.xlplatform.endpoints.servlet.FlexAkkaStreamServlet;
import java.net.ServerSocket;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.crypto.SecretKey;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.SessionTrackingMode;
import nl.javadude.t2bus.Subscribe;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public class Server {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private static final String SPRING_CONFIG = "classpath:spring/deployit-context.xml,classpath:deployit-security.xml,classpath*:hotfix-context.xml";
    private final ServerConfiguration serverConfiguration;
    private final String name;
    private final String springConfig;
    private final String contextPath;
    private final ServerLaunchOptions launchOptions;
    private final ServerState serverState = ServerState.getInstance();
    private org.eclipse.jetty.server.Server jettyServer;
    private WebAppContext contextRoot;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger = LoggerFactory.getLogger(Server.class);

    public static void start(String name, ServerLaunchOptions launchOptions, ServerConfigFile configFile) {
        ServerConfiguration config = configFile.loadConfig(false, false);
        String repositoryKeyStorePassword = launchOptions.getRepositoryKeystorePassword() != null ? launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            System.out.println("Could not load the encryption key. " + name + " will not start.");
            return;
        }
        config.loadEncryptedPasswords();
        configFile.saveDirtyConfiguration(config);
        Server server = new Server(name, config, launchOptions);
        server.start();
    }

    public Server(String name, ServerConfiguration configuration, ServerLaunchOptions launchOptions) {
        this(name, configuration, launchOptions, SPRING_CONFIG, "deployit");
    }

    public Server(String name, ServerConfiguration configuration, ServerLaunchOptions launchOptions, String springConfig, String contextPath) {
        this.serverConfiguration = configuration;
        this.name = name;
        this.launchOptions = launchOptions;
        this.springConfig = springConfig;
        this.contextPath = contextPath;
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (this.portIsAvailable()) {
            this.setupJetty();
            this.setupAccessLog();
            Server.bootPlugins();
            this.setupSpring();
            this.setupMaintenanceFilter();
            this.setupRest();
        } else {
            logger.error("Cannot start {}; port {} already in use.", (Object)name, (Object)this.serverConfiguration.getHttpPort());
            logger.error("Perhaps another instance of {} is running.", (Object)name);
            System.exit(1);
        }
    }

    private boolean portIsAvailable() {
        try {
            ServerSocket socket = new ServerSocket(this.serverConfiguration.getHttpPort());
            socket.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void setupJetty() {
        ServerConnector connector;
        int port = this.serverConfiguration.getHttpPort();
        String webContextRoot = this.serverConfiguration.getWebContextRoot();
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, webContextRoot, documentRootPackage});
        }
        this.jettyServer = new org.eclipse.jetty.server.Server((ThreadPool)this.buildThreadPool());
        if (this.serverConfiguration.isSsl()) {
            logger.debug("Setting up Jetty to use SSL");
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(this.serverConfiguration.getKeyStorePath());
            sslContextFactory.setKeyStorePassword(this.serverConfiguration.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(this.serverConfiguration.getKeyStoreKeyPassword());
            sslContextFactory.setExcludeCipherSuites(new String[]{"^.*_(MD5|SHA1)$"});
            String protocol = this.serverConfiguration.getSslProtocol();
            if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
                sslContextFactory.setProtocol(protocol);
            }
            connector = new ServerConnector(this.jettyServer, sslContextFactory);
        } else {
            connector = new ServerConnector(this.jettyServer);
        }
        connector.setIdleTimeout((long)this.serverConfiguration.getHttpIdleTimeoutMillis().intValue());
        connector.setHost(this.serverConfiguration.getHttpBindAddress());
        connector.setPort(port);
        logger.info("Connector listen {} on {}:{}", new Object[]{this.serverConfiguration.isSsl() ? "secure" : "no-secure", connector.getHost(), connector.getPort()});
        this.jettyServer.addConnector((Connector)connector);
        this.jettyServer.setStopTimeout(1000L);
        CustomErrorHandler errorHandler = new CustomErrorHandler(new HttpErrorHandler[]{new LicenseMissingErrorHandler(), new RootPageMissingErrorHandler(this.serverConfiguration.getWebWelcomePage())});
        this.contextRoot = new WebAppContext((HandlerContainer)this.jettyServer, webContextRoot, Server.newSessionHandler(), (SecurityHandler)new ConstraintSecurityHandler(), new ServletHandler(), (ErrorHandler)errorHandler, 0);
        this.contextRoot.addFilter(FlexLicenseValidationFilter.class, "/deployit/*", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("whiteListedPaths", "");
        this.contextRoot.addFilter(NoOptionsFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        if (this.serverConfiguration.getWebWelcomePage() != null) {
            this.contextRoot.addFilter(RootPageForwardFilter.class, "/", EnumSet.of(DispatcherType.REQUEST)).setInitParameter("ForwardTarget", this.serverConfiguration.getWebWelcomePage());
        }
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/reports/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(RequestHeadersEncodedAsParametersFilter.class, "/deployit/repository/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.setClassLoader(Thread.currentThread().getContextClassLoader());
        ServletHolder extensionApiServletHolder = new ServletHolder(FlexAkkaStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        this.contextRoot.addEventListener((EventListener)new AkkaStreamServletInitializer());
        this.contextRoot.addServlet(extensionApiServletHolder, "/api/*");
        this.contextRoot.addFilter(NoCacheFilter.class, "/", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder registrationServletHolder = new ServletHolder(LicenseRegistrationServlet.class);
        registrationServletHolder.setInitParameter("productName", "XL Deploy");
        registrationServletHolder.setInitParameter("productLogoUrl", "images/xl_deploy_logo_green.svg");
        registrationServletHolder.setInitParameter("activationUrl", "https://xebialabs.com/products/xl-deploy/trial/activation");
        this.contextRoot.addServlet(registrationServletHolder, "/productregistration/*");
        ServletHolder defaultServletHolder = new ServletHolder();
        defaultServletHolder.setServlet((Servlet)new ClassPathResourceContentServlet(documentRootPackage));
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        this.contextRoot.addServlet(defaultServletHolder, "/");
    }

    private void setupAccessLog() {
        this.contextRoot.addFilter(AccessLogFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private static SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setSessionCookie("SESSION_XLD");
        sessionHandler.setHttpOnly(true);
        return sessionHandler;
    }

    private QueuedThreadPool buildThreadPool() {
        return new QueuedThreadPool(this.serverConfiguration.getMaxThreads(), this.serverConfiguration.getMinThreads());
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupMaintenanceFilter() {
        FilterHolder maintenanceFilterHolder = this.contextRoot.addFilter(MaintenanceModeFilter.class, "*", EnumSet.of(DispatcherType.REQUEST));
        maintenanceFilterHolder.setInitParameter("maintenance.forbidden_paths", this.serverConfiguration.getMaintenanceForbiddenRequests());
        maintenanceFilterHolder.setInitParameter("maintenance.context_root", this.serverConfiguration.getWebContextRoot());
    }

    private void setupSpring() {
        ServerConfiguration.setInstance((ServerConfiguration)this.serverConfiguration);
        ServerLaunchOptions.setInstance((ServerLaunchOptions)this.launchOptions);
        Map params = this.contextRoot.getInitParams();
        params.put(SPRING_CTX_CFG_LOCATION_KEY, this.springConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + (String)params.get(SPRING_CTX_CFG_LOCATION_KEY));
        }
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.contextRoot.addFilter(filter, "/login", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/logout", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/" + this.contextPath + "/*", EnumSet.of(DispatcherType.REQUEST));
        this.contextRoot.addFilter(filter, "/api/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupRest() {
        this.contextRoot.addEventListener((EventListener)new ResteasyBootstrap());
        this.contextRoot.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.contextRoot.getInitParams().put("resteasy.servlet.mapping.prefix", "/" + this.contextPath);
        this.contextRoot.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.contextRoot.addServlet(servletHolder, "/" + this.contextPath + "/*");
        this.contextRoot.setResourceBase(".");
        DefaultStorageProvider.setInstance((StorageProvider)new Mime4jStorageProvider());
    }

    private void setupHotStandby(WebApplicationContext wac) {
        HotStandbyActorSystem actorSystem = (HotStandbyActorSystem)wac.getAutowireCapableBeanFactory().createBean(HotStandbyActorSystem.class);
        actorSystem.boot();
    }

    public void start() {
        try {
            EventBusHolder.register((Object)this.serverState);
            EventBusHolder.register((Object)this);
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.jettyServer.start();
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            this.setupHotStandby(DeployitSpringContextLoaderListener.getWebApplicationContext());
            if (logger.isDebugEnabled()) {
                logger.debug("Jetty started");
            }
            this.createShutdownEventThreadAndShutdownHook();
            EventBusHolder.publish((Object)new SystemStartedEvent());
        }
        catch (Exception e) {
            logger.error("Error occurred while starting Jetty", (Throwable)e);
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.jettyServer.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.jettyServer.stop();
                logger.info("{} has shut down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.error("Shutting down {} because a shutdown event was received.", (Object)Server.this.name);
                Server.this.stop();
            }
        });
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.error("Shutting down {} from the JVM shutdown hook because the process is being terminated.", (Object)Server.this.name);
                Server.this.stop();
            }
        }));
    }

    public WebAppContext getContextRoot() {
        return this.contextRoot;
    }

    @Subscribe
    public void startListener(SystemStartedEvent event) {
        logger.info("{} has started.", (Object)this.name);
        logger.info("You can now point your browser to {}", (Object)this.serverConfiguration.getServerUrl());
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.trace("Received shutdown event.");
        shutdownLatch.countDown();
    }
}

