package datasets

import com.xebialabs.deployit.repository.RepositoryServiceHolder
import com.xebialabs.deployit.rest.test.api.DataSet
import ai.digital.deploy.tasker.common.TaskType._
import dsl.{CiUtils, EarUtils, TaskUtils}

import scala.util.Random

object ReportsPerformanceSet extends DataSet with TaskUtils with EarUtils with CiUtils {
  override def name(): String = "ReportsPerformanceSet"

  override def generateSet(args: List[String]): Unit = {
    val defaults: List[Int] = List(365, 100, 3, 4, 5, 6)
    val testArgs: List[Int] = (args.map(Integer.parseInt) ++ defaults.drop(args.length)) take 6

    testArgs match {
      case List(days, deploymentsPerDay, blocks, subblocks, subsubblocks, stepsPerLeafBlock) =>

        create { c =>
          (0 to 9).foreach(i => createEmptyPackage(c, app(i), 1))
          (0 to 6).foreach(i => c.environment(env(i))(List()))
        }

        val repository = RepositoryServiceHolder.getRepositoryService
        val appIds = (0 to 9).map(app).map("/Applications/" + _).toList
        val envIds = (0 to 6).map(env).map("/Environments/" + _).toList
        val apps = readCisAsMap(appIds, repository)
        val envs = readCisAsMap(envIds, repository)


        for (daysAgo <- 1 to days) {
          (1 to deploymentsPerDay).foreach(i =>
            createCurrentTask(apps(randomApp), "1.0", envs(randomEnv), daysAgo, randomDuration(Range(10, 70)), randomTaskState, randomTaskType
              , _.withBlocks(List(blocks, subblocks, subsubblocks), stepsPerLeafBlock)
            )
          )
          (1 to (deploymentsPerDay / 10)).foreach(i =>
            createControlTask("MyControlTask", apps(randomApp), daysAgo, randomDuration(Range(3, 8)), randomTaskState)
          )

        }
    }
  }

  private def randomDuration(range: Range) = range.start + Random.nextInt(range.length)

  private val taskStates = Array(dsl.TaskState.SUCCESSFUL, dsl.TaskState.SUCCESSFUL, dsl.TaskState.FAILED, dsl.TaskState.SUCCESSFUL, dsl.TaskState.ABORTED)
  private val taskStatesLength = taskStates.length

  private def randomTaskState = taskStates(Random.nextInt(taskStatesLength))

  private val taskTypes = Array(INITIAL, UPGRADE, UNDEPLOY, ROLLBACK, INITIAL, UPGRADE, UNDEPLOY, INITIAL, UPGRADE)
  private val taskTypesLength = taskTypes.length

  private def randomTaskType = taskTypes(Random.nextInt(taskTypesLength))

  private def app(i: Int) = s"MyApp$i"

  private def randomApp = app(Random.nextInt(10))

  private def env(i: Int) = s"MyEnv$i"

  private def randomEnv = env(Random.nextInt(7))
}
