/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.test;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;

@SuppressWarnings("serial")
public class TestStep implements Step {
	
	private TestConfigurationItem testCi;
	
	public TestStep(TestConfigurationItem testCi) {
		this.testCi = testCi;
		if (testCi.getStepDelayTimeInMilliSeconds() < 1) {
			throw new ResolutionException("stepDelayTimeInMilliSeconds cannot be less then 1");
		}
	}

	public boolean execute(StepExecutionContext ctx) {
		int kBOfLogToGeneratePerSecond = testCi.getAmountOfKBLogFiles() / testCi.getStepDelayTimeInMilliSeconds();
		
		try {
			for (int i = 0; i < testCi.getStepDelayTimeInMilliSeconds() / 100; i++) {
				Thread.sleep(100);
				ctx.logOutput(generateLog(kBOfLogToGeneratePerSecond));
			}
		} catch (InterruptedException e) {
			return false;
		}
		return true;
	}

	private String generateLog(int kBOfLogToGeneratePerSecond) {
		String OneKBOfLorum = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam lacinia odio in dui sollicitudin ullamcorper. Quisque id lectus justo, vitae hendrerit dolor. Sed mollis eros id lectus ultricies dictum. Nulla eu nulla felis. Vestibulum dapibus facilisis risus, ut mollis lacus dictum et. Praesent dignissim nunc et sapien viverra egestas. Fusce vel elit urna, quis consectetur tellus. Suspendisse convallis nulla nec nisl commodo et commodo eros mattis. Donec fringilla, est sit amet lobortis rhoncus, arcu nisl lobortis tortor, eget auctor sapien ante ut velit. Proin egestas sem leo. Curabitur vitae nunc eget eros tincidunt vulputate. Ut lobortis scelerisque ligula, sit amet cursus nisl gravida quis. Pellentesque tempor massa quis eros interdum tristique sodales ligula facilisis. Nullam dignissim consequat lorem, eleifend suscipit justo consequat eget. Quisque orci lectus, interdum in gravida a, ultricies at diam. Etiam eget mauris et massa imperdiet commodo vel a nibh. Vestibulum nisi magna, blandit quis turpis duis.\n";
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < kBOfLogToGeneratePerSecond; i ++) {
			sb.append(OneKBOfLorum);		
		}
		return sb.toString();
	}

	public String getDescription() {
		return "Going to wait for " + testCi.getStepDelayTimeInMilliSeconds() + "ms and generate " + testCi.getAmountOfKBLogFiles() + "KB of (Lorum ipsum) log file";
	}

}
