/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.test;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.test.TestConfigurationItem;

public abstract class TestStep
implements Step {
    protected TestConfigurationItem testCi;

    public TestStep(TestConfigurationItem testCi) {
        this.testCi = testCi;
        if (testCi.getStepDelayTimeInMilliSeconds() < 1) {
            throw new ResolutionException("stepDelayTimeInMilliSeconds retrieved from a test CI of type " + ((Object)((Object)testCi)).getClass() + " is less then 1");
        }
    }

    public boolean execute(StepExecutionContext ctx) {
        int kBOfLogToGeneratePerSecond = this.testCi.getAmountOfKBLogFiles() / (this.testCi.getStepDelayTimeInMilliSeconds() / 1000) + 1;
        try {
            for (int i = 0; i < this.testCi.getStepDelayTimeInMilliSeconds() / 100; ++i) {
                Thread.sleep(100L);
                ctx.logOutput(this.generateLog(kBOfLogToGeneratePerSecond));
            }
        }
        catch (InterruptedException e) {
            ctx.logError("Thread.sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private String generateLog(int kBOfLogToGeneratePerSecond) {
        String OneKBOfLorum = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam lacinia odio in dui sollicitudin ullamcorper. Quisque id lectus justo, vitae hendrerit dolor. Sed mollis eros id lectus ultricies dictum. Nulla eu nulla felis. Vestibulum dapibus facilisis risus, ut mollis lacus dictum et. Praesent dignissim nunc et sapien viverra egestas. Fusce vel elit urna, quis consectetur tellus. Suspendisse convallis nulla nec nisl commodo et commodo eros mattis. Donec fringilla, est sit amet lobortis rhoncus, arcu nisl lobortis tortor, eget auctor sapien ante ut velit. Proin egestas sem leo. Curabitur vitae nunc eget eros tincidunt vulputate. Ut lobortis scelerisque ligula, sit amet cursus nisl gravida quis. Pellentesque tempor massa quis eros interdum tristique sodales ligula facilisis. Nullam dignissim consequat lorem, eleifend suscipit justo consequat eget. Quisque orci lectus, interdum in gravida a, ultricies at diam. Etiam eget mauris et massa imperdiet commodo vel a nibh. Vestibulum nisi magna, blandit quis turpis duis.\n";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < kBOfLogToGeneratePerSecond; ++i) {
            sb.append(OneKBOfLorum);
        }
        return sb.toString();
    }
}

