package com.xebialabs.deployit.plugin.test;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.BaseConfigurationItem;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.MiddlewareResource;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;

import java.io.Serializable;
import java.util.List;

@ConfigurationItem
public class DummyDatasource extends BaseConfigurationItem implements Serializable, MiddlewareResource {

    @ConfigurationItemProperty
    private String driver;

    @ConfigurationItemProperty
    private String username;

    @ConfigurationItemProperty(password = true)
    private String password;

    @ConfigurationItemProperty
    private String url;

    @ConfigurationItemProperty
    private List<KeyValuePair> settings = Lists.newArrayList();

    public String getDriver() {
        return driver;
    }

    public void setDriver(final String driver) {
        this.driver = driver;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(final String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(final String password) {
        this.password = password;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(final String url) {
        this.url = url;
    }

    public List<KeyValuePair> getSettings() {
        return settings;
    }

    public void setSettings(final List<KeyValuePair> settings) {
        this.settings = settings;
    }
}
