/*
 * Copyright (c) 2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of Xebialabs Software and Documentation is subject to the Personal
 * License Agreement.
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * ‚ÄúDocumentation‚Äù means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the Xebialabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to  (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.test.support.stubs;

import java.io.Serializable;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

@SuppressWarnings("serial")
@ConfigurationItem
public class StubConfigurationItem implements Serializable {
	@ConfigurationItemProperty
	private boolean booleanProperty;
	
	@ConfigurationItemProperty
	private String stringProperty;
	
	@ConfigurationItemProperty
	private int intProperty;
	
	private static enum EnumValues { ONE, TWO, THREE }
	
	@ConfigurationItemProperty
	private EnumValues enumProperty;
	
	private StubConfigurationItem(boolean booleanProperty, String stringProperty, 
			int intProperty, EnumValues enumProperty) {
		this.booleanProperty = booleanProperty;
		this.stringProperty = stringProperty;
		this.intProperty = intProperty;
		this.enumProperty = enumProperty;
	}

	public boolean isBooleanProperty() {
		return booleanProperty;
	}

	public String getStringProperty() {
		return stringProperty;
	}

	public int getIntProperty() {
		return intProperty;
	}

	public EnumValues getEnumProperty() {
		return enumProperty;
	}

	public void setBooleanProperty(boolean booleanProperty) {
		this.booleanProperty = booleanProperty;
	}

	public void setStringProperty(String stringProperty) {
		this.stringProperty = stringProperty;
	}

	public void setIntProperty(int intProperty) {
		this.intProperty = intProperty;
	}

	public void setEnumProperty(EnumValues enumProperty) {
		this.enumProperty = enumProperty;
	}
}
