package com.xebialabs.deployit.test.support.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;

import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.core.io.ClassPathResource;

public class VelocityUtils {

	public static String evaluateTemplate(VelocityContext context, String templateResourcePath) {
		VelocityEngine engine = new VelocityEngine();
		try {
			engine.init();
		} catch (Exception exc) {
			throw new RuntimeException("Cannot initialize Velocity", exc);
		}

		ClassPathResource templateResource = new ClassPathResource(templateResourcePath);
		InputStream dsTemplateIn;
		try {
			dsTemplateIn = templateResource.getInputStream();
		} catch (IOException exc) {
			throw new RuntimeException("Cannot open template file " + templateResourcePath, exc);
		}

		StringWriter evaluatedTemplateWriter = new StringWriter();
		try {
			engine.evaluate(context, evaluatedTemplateWriter, templateResourcePath, new InputStreamReader(dsTemplateIn));
		} catch (Exception exc) {
			throw new RuntimeException("Cannot evaluate template " + templateResourcePath, exc);
		}
		return evaluatedTemplateWriter.toString();
	}

}
