/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.support;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.cli.rest.ResponseExtractor;
import com.xebialabs.deployit.core.api.ImportablePackageProxy;
import com.xebialabs.deployit.core.api.dto.FileUpload;
import com.xebialabs.deployit.core.api.dto.RepositoryObject;
import com.xebialabs.deployit.test.support.PackageBuilderException;
import com.xebialabs.deployit.test.support.manifest.ManifestWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuilder {
    private ManifestWriter manifestWriter;
    private Map<String, Resource> files;
    private final ImportablePackageProxy importablePackageProxy;
    private static final Logger logger = LoggerFactory.getLogger(PackageBuilder.class);

    PackageBuilder(String applicationName, String version, ImportablePackageProxy importablePackageProxy) {
        this.importablePackageProxy = importablePackageProxy;
        this.manifestWriter = new ManifestWriter(applicationName, version);
        this.files = Maps.newHashMap();
    }

    public PackageBuilder addMiddleware(String entryName, String type, Map<String, String> values) {
        this.manifestWriter.addMiddlewareResourceEntry(entryName, type, values);
        return this;
    }

    public PackageBuilder addArtifact(String entryName, String type, Map<String, String> values, String fileContent) {
        this.addBinaryArtifact(entryName, type, values, fileContent.getBytes());
        return this;
    }

    public PackageBuilder addBinaryArtifact(String entryName, String type, Map<String, String> values, byte[] fileContent) {
        this.manifestWriter.addDeployableArtifactEntry(entryName, type, values);
        this.files.put(entryName, (Resource)new ByteArrayResource(fileContent));
        return this;
    }

    public PackageBuilder addFolderTypeArtifacts(String entryName, String type, Map<String, String> values, Map<String, Resource> folderFiles) {
        this.manifestWriter.addDeployableArtifactEntry(entryName, type, values);
        for (Map.Entry<String, Resource> eachEntry : folderFiles.entrySet()) {
            this.files.put(entryName + "/" + eachEntry.getKey(), eachEntry.getValue());
        }
        return this;
    }

    public RepositoryObject uploadAndImport() {
        byte[] createdDar = this.createDar();
        FileUpload fileUpload = new FileUpload();
        fileUpload.setFileData(createdDar);
        Response response = this.importablePackageProxy.importUploadedPackage(fileUpload);
        return (RepositoryObject)new ResponseExtractor(response).getEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createDar() {
        ByteArrayOutputStream jarFileOut = null;
        jarFileOut = new ByteArrayOutputStream();
        JarOutputStream jarOut = null;
        try {
            jarOut = new JarOutputStream((OutputStream)jarFileOut, this.manifestWriter.getManifest());
            for (Map.Entry<String, Resource> eachFile : this.files.entrySet()) {
                String filename = eachFile.getKey();
                Resource resource = eachFile.getValue();
                jarOut.putNextEntry(new JarEntry(filename));
                InputStream resourceIn = resource.getInputStream();
                try {
                    IOUtils.copy((InputStream)resourceIn, (OutputStream)jarOut);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)resourceIn);
                }
                jarOut.closeEntry();
            }
        }
        catch (IOException ioe) {
            try {
                logger.error("found IO exception while creating the dar");
                throw new PackageBuilderException(ioe.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarOut);
                IOUtils.closeQuietly((OutputStream)jarFileOut);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)jarOut);
        IOUtils.closeQuietly((OutputStream)jarFileOut);
        return jarFileOut.toByteArray();
    }
}

