/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.test.ManifestWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManifestWriterTest {
    private ManifestWriter manifestWriter;
    private String application = "dummyapp";
    private String version = "1.0";

    @Before
    public void setup() {
        this.manifestWriter = new ManifestWriter(this.application, this.version);
    }

    @Test
    public void shouldBeAbleToWriteBareMinimumManifest() throws IOException {
        Manifest manifest = this.manifestWriter.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        Assert.assertEquals((String)"1.2", (String)mainAttributes.getValue("Deployit-Package-Format-Version"));
        Assert.assertEquals((String)this.application, (String)mainAttributes.getValue("CI-Application"));
        Assert.assertEquals((String)this.version, (String)mainAttributes.getValue("CI-Version"));
    }

    @Test
    public void shouldBeAbleToAddEntryForMiddlewareResource() throws IOException {
        String name = "DummyMiddleware";
        String type = "DummyMiddlwareTypeName";
        HashMap values = Maps.newHashMap();
        values.put("key1", "value1");
        values.put("key2", "value2");
        this.manifestWriter.addMiddlewareResourceEntry(name, type, values);
        Manifest manifest = this.manifestWriter.getManifest();
        Attributes attributes = manifest.getAttributes(name);
        Assert.assertEquals((String)type, (String)attributes.getValue("CI-Type"));
        Assert.assertEquals((String)"value1", (String)attributes.getValue("CI-key1"));
        Assert.assertEquals((String)"value2", (String)attributes.getValue("CI-key2"));
    }

    @Test
    public void shouldBeAbleToAddEntryForDeployableArtifact() throws IOException {
        String name = "DummyArtifact.war";
        String type = "DummyArtifactType";
        HashMap values = Maps.newHashMap();
        values.put("name", "DummyArtifact");
        this.manifestWriter.addDeployableArtifactEntry(name, type, values);
        Manifest manifest = this.manifestWriter.getManifest();
        Attributes attributes = manifest.getAttributes(name);
        Assert.assertEquals((String)((String)values.get("name")), (String)attributes.getValue("CI-Name"));
        Assert.assertEquals((String)type, (String)attributes.getValue("CI-Type"));
    }
}

