/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.test.webapp.builder;

import com.xebialabs.deployit.test.deployment.tester.DeployedItemTester;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DeployedItemTestServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String deploymentTesters = this.getServletContext().getInitParameter("deployed.item.testers");
        List<DeployedItemTester> deployedItemTesters = this.getTesterInstances(deploymentTesters);
        resp.setContentType("text/html;charset=UTF-8");
        PrintWriter out = resp.getWriter();
        try {
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Deployment Test Results</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Deployment Test Results</h1>");
            for (DeployedItemTester eachTester : deployedItemTesters) {
                String testResult = eachTester.testDeployedItem() ? "OK" : "FAILED";
                out.print(eachTester.getTestName() + "=" + testResult);
                out.println("<br/>");
            }
            out.println("</body>");
            out.println("</html>");
        }
        finally {
            out.close();
        }
    }

    private List<DeployedItemTester> getTesterInstances(String deploymentTesters) {
        String[] testerDetailsArray;
        ArrayList<DeployedItemTester> testers = new ArrayList<DeployedItemTester>();
        for (String eachTesterDetails : testerDetailsArray = this.parseTesterDetails(deploymentTesters)) {
            Map<String, String> details = this.parseTesterTestParams(eachTesterDetails);
            System.out.println("details=>" + details);
            String testerFullyQualifiedName = details.get("name");
            if (testerFullyQualifiedName == null) continue;
            this.instantiateTesterInstance(testers, testerFullyQualifiedName, details);
        }
        return testers;
    }

    private void instantiateTesterInstance(List<DeployedItemTester> testers, String testerFullyQualifiedName, Map<String, String> details) {
        try {
            Class<?> testerClass = Class.forName(testerFullyQualifiedName, false, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = testerClass.getConstructor(Map.class);
            Object testerInstance = constructor.newInstance(details);
            DeployedItemTester newInstance = (DeployedItemTester)DeployedItemTester.class.cast(testerInstance);
            testers.add(newInstance);
        }
        catch (Exception e) {
            System.out.println("Found exception while instantiating class of type:" + testerFullyQualifiedName + "\n" + e.getMessage());
        }
    }

    private String[] parseTesterDetails(String deploymentTesters) {
        String[] stringArray;
        if (deploymentTesters.contains("||")) {
            stringArray = deploymentTesters.split("\\|\\|");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = deploymentTesters;
        }
        return stringArray;
    }

    private Map<String, String> parseTesterTestParams(String eachTesterDetails) {
        String[] testerDetailUnits;
        String[] stringArray;
        HashMap<String, String> testParams = new HashMap<String, String>();
        if (eachTesterDetails.contains("|")) {
            stringArray = eachTesterDetails.split("\\|");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = eachTesterDetails;
        }
        for (String eachDetailUnit : testerDetailUnits = stringArray) {
            String[] keyValue = eachDetailUnit.split("=");
            if (keyValue.length != 2) continue;
            testParams.put(keyValue[0], keyValue[1]);
        }
        return testParams;
    }
}

