/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

import com.xebialabs.deployit.plugin.tomcat.ci.TomcatManagedServer;

public class TomcatManagerAppUtils {

	private TomcatManagedServer server;
	private String baseUrl;

	public TomcatManagerAppUtils(TomcatManagedServer server) {
		if (server != null) {
			this.server = server;
			this.baseUrl = server.getManagerAppUrl();
		}
	}

	/**
	 * @param contextRoot
	 * @param warLocation
	 * @return
	 * @throws IOException
	 */
	public String deploy(String contextRoot, String warLocation) throws IOException {
		String url = baseUrl + "/deploy?path=/" + contextRoot + "&war=file:" + warLocation;
		return executeManagerAppCommand(url);
	}

	/**
	 * @return true if tomcat is reachable by it's baseURL
	 */
	public boolean checkTomcatReachable(String url) {
		return isTomcatReachableAndRunning(url);
	}

	/**
	 * @param applicationName
	 * @return
	 * @throws IOException
	 */
	public boolean checkApplicationIsDeployed(String applicationName) {
		String url = baseUrl + "/list";
		String execetionResultStr;
		try {
			execetionResultStr = executeManagerAppCommand(url);
		} catch (HttpException e) {
			throw new RuntimeException("error found in calling manager URL " + url, e);
		} catch (IOException e) {
			throw new RuntimeException("error found in calling manager URL " + url, e);
		}
		return execetionResultStr.contains("/" + applicationName + ":running");
	}

	/**
	 * @param contextRoot
	 * @return
	 * @throws IOException
	 */
	public String undeploy(String contextRoot) throws IOException {
		String url = baseUrl + "/undeploy?path=/" + contextRoot;
		return executeManagerAppCommand(url);
	}

	private String executeManagerAppCommand(String url) throws IOException, HttpException {
		HttpMethod method = invokeClientWithWithMangerUrl(url, true);
		return getResponseFromUrl(method);
	}

	private HttpMethod invokeClientWithWithMangerUrl(String url, boolean useManagerCredentials) throws IOException, HttpException {
		HttpClient client = new HttpClient();
		GetMethod method = new GetMethod(url);

		if (useManagerCredentials) {
			Credentials defaultcreds = new UsernamePasswordCredentials(server.getManagerUsername(), server.getManagerPassword());
			client.getState().setCredentials(AuthScope.ANY, defaultcreds);
			method.setDoAuthentication(true);
		}

		int status = 0;
		status = client.executeMethod(method);

		if (status != HttpStatus.SC_OK && status != HttpStatus.SC_NOT_FOUND) {
			throw new RuntimeException("Can't access the manager app from URL " + url + ". HTTP status: " + status);
		}
		return method;
	}

	private boolean isTomcatReachableAndRunning(String url) {
		HttpMethod method;
		try {
			method = invokeClientWithWithMangerUrl(url, false);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		Header[] responseHeaders = method.getResponseHeaders();
		for (Header header : responseHeaders) {
			if (header.getValue().contains("Apache-Coyote")) {
				return true;
			}
		}
		return false;
	}

	private String getResponseFromUrl(HttpMethod method) throws IOException {
		BufferedReader reader;
		reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
		StringBuffer responseBody = new StringBuffer();

		String readLine;
		while ((readLine = reader.readLine()) != null) {
			responseBody.append(readLine + "\n");
		}
		reader.close();

		method.releaseConnection();
		return responseBody.toString();
	}

	public String getBaseUrl() {
		return baseUrl;
	}
}
