/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.MappingAgnosticStepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatActiveMQConnectionFactory;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatResourceMapping;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.CreateTomcatActiveMQConnectionFactoryStep;
import com.xebialabs.deployit.plugin.tomcat.step.DestroyTomcatActiveMQConnectionFactoryStep;
import org.apache.commons.lang.StringUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ActiveMQConnectionFactoryToTomcatServerMapper extends MappingAgnosticStepGeneratingMapper<TomcatActiveMQConnectionFactory, TomcatResourceMapping, TomcatUnmanagedServer> {

	private Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>[] tomcatServerMappers;

	public ActiveMQConnectionFactoryToTomcatServerMapper(Change<Deployment> change, Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>... tomcatServerMappers) {
		super(change);
		this.tomcatServerMappers = tomcatServerMappers;
	}

	@Override
	protected void generateAdditionStepsForAddedMapping(TomcatActiveMQConnectionFactory newMappingSource, TomcatUnmanagedServer newMappingTarget, List<Step> steps) {

		Set<TomcatWarMapping> addedAndModifiedWarMappings = getAddedAndModifiedWarMappings();

		for (TomcatWarMapping warMapping : addedAndModifiedWarMappings) {
			if (warMapping.getTarget().equals(newMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					steps.add(new CreateTomcatActiveMQConnectionFactoryStep(newMappingTarget, newMappingSource, warMapping));
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
				}
			}

		}
	}

	@Override
	protected void generateDeletionStepsForDeletedMapping(TomcatActiveMQConnectionFactory oldMappingSource, TomcatUnmanagedServer oldMappingTarget, List<Step> steps) {

		Set<TomcatWarMapping> deletedAndModifiedMappings = getdeletedAndModifiedWarMappings();

		for (TomcatWarMapping warMapping : deletedAndModifiedMappings) {
			if (warMapping.getTarget().equals(oldMappingTarget)) {
				if (!StringUtils.isBlank(warMapping.getContextRoot())) {
					steps.add(new DestroyTomcatActiveMQConnectionFactoryStep(oldMappingTarget, oldMappingSource, warMapping));
				} else {
					throw new ResolutionException("No war mapping with a set context root was found for " + warMapping.getSource());
				}
			}

		}
	}

	private Set<TomcatWarMapping> getdeletedAndModifiedWarMappings() {
		Set<TomcatWarMapping> warMappings = new HashSet<TomcatWarMapping>();
		for (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getOldMappings());
		}
		return warMappings;
	}

	private Set<TomcatWarMapping> getAddedAndModifiedWarMappings() {
		Set<TomcatWarMapping> warMappings = new HashSet<TomcatWarMapping>();
		for (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer> mapper : tomcatServerMappers) {
			warMappings.addAll(mapper.getNewMappings());
		}
		return warMappings;
	}
}