/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.mapper;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.mapper.StepGeneratingMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatConfigurationFilesMapping;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.steps.CopyStep;
import com.xebialabs.deployit.steps.DeleteStep;
import java.io.File;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFilesToTomcatServerMapper
extends StepGeneratingMapper<ConfigurationFiles, TomcatConfigurationFilesMapping, TomcatServer> {
    public ConfigurationFilesToTomcatServerMapper(Change<Deployment> change) {
        super(change, false);
    }

    protected void generateAdditionStepsForAddedMapping(ConfigurationFiles newMappingSource, TomcatConfigurationFilesMapping m, TomcatServer newMappingTarget, List<Step> steps) {
        Map propertyMap = KeyValuePair.toMap((List)m.getKeyValuePairs());
        String targetDirectory = newMappingTarget.getTomcatLibDirectory();
        steps.add((Step)new CopyStep(Host.getLocalHost(), ((ConfigurationFiles)m.getSource()).getLocation(), ((TomcatServer)((Object)m.getTarget())).getHost(), targetDirectory, propertyMap));
    }

    protected void generateDeletionStepsForDeletedMapping(ConfigurationFiles oldMappingSource, TomcatConfigurationFilesMapping m, TomcatServer oldMappingTarget, List<Step> steps) {
        String targetDirectory = oldMappingTarget.getTomcatLibDirectory();
        for (File f : oldMappingSource.getFiles()) {
            String fileToDelete = new File(targetDirectory, f.getName()).getPath();
            steps.add((Step)new DeleteStep(((TomcatServer)((Object)m.getTarget())).getHost(), fileToDelete));
        }
    }
}

