/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatManagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatDeploymentStepBase;
import java.io.IOException;

public class TomcatHttpBasedDeployApplicationStep
extends TomcatDeploymentStepBase {
    public TomcatHttpBasedDeployApplicationStep(TomcatServer target, TomcatWarMapping mapping) {
        super(target, mapping);
        this.setDescription("Deploy WAR file " + mapping.getSource() + " to Tomcat server " + (Object)((Object)this.server) + " using manager application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.server.connectToAdminHost();
        try {
            HostSession lhs = Host.getLocalHost().getHostSession();
            try {
                HostFile deployedWarFile = this.copyWarToTargetTempDirectory(lhs, rhs, ctx);
                String deployedWarPath = deployedWarFile.getPath();
                String deploymentResult = this.deployUsingManagerApp(ctx, deployedWarPath);
                if (deploymentResult.startsWith("OK")) {
                    ctx.logOutput("Done.");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException exc) {
                ctx.logError("Cannot deploy " + this.artifact + " to manager of " + (Object)((Object)this.server), (Throwable)exc);
            }
            finally {
                lhs.close();
            }
        }
        finally {
            rhs.close();
        }
        return false;
    }

    private HostFile copyWarToTargetTempDirectory(HostSession lhs, HostSession rhs, StepExecutionContext ctx) {
        HostFile sourceFile = lhs.getFile(this.artifact.getLocation());
        String artifactTargetFileName = this.getArtifactTargetFileName();
        HostFile targetTmpFile = rhs.getTempFile(artifactTargetFileName);
        ctx.logOutput("Copying application artifact to " + targetTmpFile.getPath() + " on " + this.server.getHost());
        HostFileUtils.copyFile((HostFile)sourceFile, (HostFile)targetTmpFile);
        return targetTmpFile;
    }

    private String deployUsingManagerApp(StepExecutionContext ctx, String deployedWarPath) throws IOException {
        String contextRootPath = this.isContextSet() ? this.contextRoot : this.artifact.getName();
        TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils((TomcatManagedServer)this.server);
        ctx.logOutput("Deploying " + this.getArtifactTargetFileName() + " using manager app url " + managerAppUtils.getBaseUrl());
        String deploymentResult = managerAppUtils.deploy(contextRootPath, deployedWarPath);
        ctx.logOutput(deploymentResult);
        return deploymentResult;
    }
}

