package com.xebialabs.deployit.plugin.tomcat.ci;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.mapping.Mapping;

import java.util.List;
import java.util.Map;

/**
 */
@ConfigurationItem
public class TomcatJNDIResourcesMapping extends Mapping<TomcatJNDIResources, TomcatUnmanagedServer> {
	@ConfigurationItemProperty(description = "Resources links that are to stored in the Tomcat JNDI tree")
	private List<ResourceLink> resourceLinks = Lists.newArrayList();

	public TomcatJNDIResourcesMapping() {

	}

	public TomcatJNDIResourcesMapping(TomcatJNDIResources jndiProperties, TomcatUnmanagedServer server) {
		super(jndiProperties, server);
	}

	public List<ResourceLink> getResourceLinks() {
		return resourceLinks;
	}

	public Map<String, ResourceLinkValue> getResourceLinksAsMap() {
		return ResourceLink.toMap(resourceLinks);
	}

	public void setResourceLinks(List<ResourceLink> resourceLinks) {
		this.resourceLinks = resourceLinks;
	}

	public void addResourceLink(ResourceLink link) {
		if (resourceLinks == null) {
			resourceLinks = Lists.newArrayList();
		}
		resourceLinks.add(link);
	}
}
