/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.tomcat.step;

import java.io.IOException;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.tomcat.TomcatManagerAppUtils;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatManagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;

@SuppressWarnings("serial")
public class TomcatHttpBasedUndeployApplicationStep extends TomcatDeploymentStepBase {

	public TomcatHttpBasedUndeployApplicationStep(TomcatServer oldTarget, TomcatWarMapping mapping) {
		super(oldTarget, mapping);
		setDescription("Undeploy WAR file " + mapping.getSource() + " from Tomcat server " + oldTarget + " using manager application");
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = null;
		try {
			rhs = server.getHost().getHostSession();
			String deploymentResult = undeployUsingManagerApp(ctx);

			if (deploymentResult.startsWith("OK")) {
				removeAppContextFile(rhs);
			} else {
				return false;
			}
			ctx.logOutput("Done.");
			return true;
		} finally {
			rhs.close();
		}

	}

	private void removeAppContextFile(HostSession rhs) {
		if (isContextSet()) {
			// delete the context file
			HostFile contextFile = rhs.getFile(getContextFilePathOnServer());
			contextFile.delete();
		}
	}

	private String undeployUsingManagerApp(StepExecutionContext ctx) {
		String deploymentResult = "";
		try {
			TomcatManagerAppUtils managerAppUtils = new TomcatManagerAppUtils((TomcatManagedServer) server);
			ctx.logOutput("Undeploying " + getArtifactTargetFileName() + " using manager app url " + managerAppUtils.getBaseUrl());
			String contextRootPath = isContextSet() ? contextRoot : artifact.getName();
			deploymentResult = managerAppUtils.undeploy(contextRootPath);
			ctx.logOutput(deploymentResult);
		} catch (IOException exc) {
			ctx.logError("Cannot undeploy " + mapping.getSource() + " from manager of " + server, exc);
		}
		return deploymentResult;
	}

}
