/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.runbook;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.mapper.Mapper;
import com.xebialabs.deployit.mapper.artifact.ConfigurationFilesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.GenericFolderToHostMapper;
import com.xebialabs.deployit.mapper.artifact.LibrariesToHostMapper;
import com.xebialabs.deployit.mapper.artifact.SqlFolderToDatabaseMapper;
import com.xebialabs.deployit.mapper.artifact.SqlScriptToDatabaseMapper;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatUnmanagedServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.mapper.ActiveMQConnectionFactoryToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.ConfigurationFilesToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.ContextFilesToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.DatasourceToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.LibrariesToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.TomcatJndiResourcesToTomcatServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.WarToTomcatManagedServerMapper;
import com.xebialabs.deployit.plugin.tomcat.mapper.WarToTomcatUnmanagedServerMapper;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStartServerStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStopServerStep;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatWaitStep;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatDeploymentRunBook
extends SingleTypeHandlingRunBook<Deployment> {
    public TomcatDeploymentRunBook() {
        super(Deployment.class);
    }

    protected void resolve(Change<Deployment> change, ChangePlan changePlan, List<Step> steps) {
        WarToTomcatUnmanagedServerMapper warToServerMapper = new WarToTomcatUnmanagedServerMapper(change);
        WarToTomcatManagedServerMapper warToServerWithManagerMapper = new WarToTomcatManagedServerMapper(change);
        DatasourceToTomcatServerMapper datasourceMapper = new DatasourceToTomcatServerMapper(change, (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>[])new Mapper[]{warToServerMapper});
        ActiveMQConnectionFactoryToTomcatServerMapper amqcfMapper = new ActiveMQConnectionFactoryToTomcatServerMapper(change, (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>[])new Mapper[]{warToServerMapper});
        TomcatJndiResourcesToTomcatServerMapper jndiMapper = new TomcatJndiResourcesToTomcatServerMapper(change, (Mapper<War, TomcatWarMapping, TomcatUnmanagedServer>[])new Mapper[]{warToServerMapper});
        LibrariesToHostMapper librariesMapper = new LibrariesToHostMapper(change);
        LibrariesToTomcatServerMapper librariesToTomcatServerMapper = new LibrariesToTomcatServerMapper(change);
        GenericFolderToHostMapper genericFolderToHostMapper = new GenericFolderToHostMapper(change);
        ConfigurationFilesToHostMapper configurationFilesToHostMapper = new ConfigurationFilesToHostMapper(change);
        ConfigurationFilesToTomcatServerMapper configurationFilesToTomcatMapper = new ConfigurationFilesToTomcatServerMapper(change);
        ContextFilesToTomcatServerMapper contextFilesToTomcatServerMapper = new ContextFilesToTomcatServerMapper(change);
        SqlFolderToDatabaseMapper sqlFoldermapper = new SqlFolderToDatabaseMapper(change);
        SqlScriptToDatabaseMapper sqlScriptMapper = new SqlScriptToDatabaseMapper(change);
        HashSet<TomcatUnmanagedServer> affectedServers = new HashSet<TomcatUnmanagedServer>();
        affectedServers.addAll(warToServerMapper.getAffectedTargets());
        if (!this.isTomcatDeployment(warToServerMapper, warToServerWithManagerMapper, datasourceMapper)) {
            return;
        }
        this.stopServers(affectedServers, steps);
        datasourceMapper.generateDeletionSteps(steps);
        amqcfMapper.generateDeletionSteps(steps);
        jndiMapper.generateDeletionSteps(steps);
        warToServerMapper.generateDeletionSteps(steps);
        configurationFilesToHostMapper.generateDeletionSteps(steps);
        configurationFilesToTomcatMapper.generateDeletionSteps(steps);
        contextFilesToTomcatServerMapper.generateDeletionSteps(steps);
        librariesMapper.generateDeletionSteps(steps);
        librariesToTomcatServerMapper.generateDeletionSteps(steps);
        genericFolderToHostMapper.generateDeletionSteps(steps);
        sqlFoldermapper.generateAdditionSteps(steps);
        sqlScriptMapper.generateAdditionSteps(steps);
        genericFolderToHostMapper.generateAdditionSteps(steps);
        librariesMapper.generateAdditionSteps(steps);
        librariesToTomcatServerMapper.generateAdditionSteps(steps);
        contextFilesToTomcatServerMapper.generateAdditionSteps(steps);
        configurationFilesToHostMapper.generateAdditionSteps(steps);
        configurationFilesToTomcatMapper.generateAdditionSteps(steps);
        datasourceMapper.generateAdditionSteps(steps);
        amqcfMapper.generateAdditionSteps(steps);
        jndiMapper.generateAdditionSteps(steps);
        warToServerMapper.generateAdditionSteps(steps);
        this.startServers(affectedServers, steps);
        warToServerWithManagerMapper.generateDeletionSteps(steps);
        warToServerWithManagerMapper.generateAdditionSteps(steps);
    }

    private boolean isTomcatDeployment(WarToTomcatUnmanagedServerMapper warToServerMapper, WarToTomcatManagedServerMapper warToServerWithManagerMapper, DatasourceToTomcatServerMapper datasourceMapper) {
        HashSet allServers = new HashSet();
        allServers.addAll(warToServerMapper.getAllTargets());
        allServers.addAll(warToServerWithManagerMapper.getAllTargets());
        allServers.addAll(datasourceMapper.getAllTargets());
        return !allServers.isEmpty();
    }

    private void stopServers(Set<TomcatUnmanagedServer> servers, List<Step> steps) {
        boolean toWait = false;
        for (TomcatUnmanagedServer eachServer : servers) {
            steps.add(new TomcatStopServerStep(eachServer));
            toWait = true;
        }
        if (toWait) {
            steps.add(new TomcatWaitStep());
        }
    }

    private void startServers(Set<TomcatUnmanagedServer> servers, List<Step> steps) {
        boolean toWait = false;
        for (TomcatUnmanagedServer eachServer : servers) {
            steps.add(new TomcatStartServerStep(eachServer));
            toWait = true;
        }
        if (toWait) {
            steps.add(new TomcatWaitStep());
        }
    }
}

