/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.tomcat.step;

import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.artifact.mapping.PlaceholderFormat;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingArchiveHostFileInputTransformer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatServer;
import com.xebialabs.deployit.plugin.tomcat.ci.TomcatWarMapping;
import com.xebialabs.deployit.plugin.tomcat.step.TomcatStepBase;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class TomcatDeploymentStepBase
extends TomcatStepBase {
    protected NamedDeployableArtifact artifact;
    private Map<String, String> properties;
    private PlaceholderFormat placeholderFormat;

    protected TomcatDeploymentStepBase(TomcatServer server, TomcatWarMapping mapping) {
        super(server, mapping);
        this.artifact = (NamedDeployableArtifact)mapping.getSource();
        this.properties = KeyValuePair.toMap((List)mapping.getKeyValuePairs());
        this.placeholderFormat = mapping.getPlaceholderFormat();
    }

    protected void setDescription(String description) {
        if (this.properties != null && !this.properties.isEmpty()) {
            description = description + " while replacing property values using " + this.placeholderFormat;
        }
        super.setDescription(description);
    }

    protected String getArtifactTargetFileName() {
        this.checkArtifactIsWar();
        return this.artifact.getName() + ".war";
    }

    protected String getExplodedWarTargetFileName() {
        this.checkArtifactIsWar();
        if (this.isContextSet()) {
            return this.server.getDeployDirPath() + this.server.getHost().getFileSeparator() + this.contextRoot;
        }
        return this.server.getDeployDirPath() + this.server.getHost().getFileSeparator() + this.artifact.getName();
    }

    protected String getDeployedArtifactPath() {
        return this.getArtifactDeploymentDirectory() + this.server.getHost().getFileSeparator() + this.getArtifactTargetFileName();
    }

    protected String getArtifactDeploymentDirectory() {
        if (!StringUtils.isBlank((String)this.mapping.getContextRoot()) && !StringUtils.isBlank((String)this.mapping.getAppBase())) {
            return this.mapping.getAppBase();
        }
        return this.server.getDeployDirPath();
    }

    protected void checkArtifactIsWar() {
        if (!(this.artifact instanceof War)) {
            throw new IllegalArgumentException("Artifact " + this.artifact + " is not a WAR");
        }
    }

    protected HostFileInputStreamTransformer getTransformer() {
        if (this.properties == null) {
            return null;
        }
        if (this.properties.isEmpty()) {
            return null;
        }
        return new LenientTemplateResolvingArchiveHostFileInputTransformer(this.properties, this.placeholderFormat);
    }
}

