/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.deployment.specification;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;

import java.io.Serializable;
import java.util.List;

/**
 * The Delta specifies what will happen to a Deployed in a Deployment.
 * if the operation == CREATE -> previous == null && deployed is set
 * if the operation == UPDATE -> previous is set && deployed is set
 * if the operation == DELETE -> previous is set && deployed == null
 * if the operation == NOOP -> previous and deployed are set to the same value.
 */
public interface Delta extends Serializable {
    Operation getOperation();

    Deployed<? extends Deployable, ? extends Container> getPrevious();
    Deployed<? extends Deployable, ? extends Container> getDeployed();

    /**
     * When this Delta is generated as part of a rollback, this can be inspected to see which
     * (intermediate) checkpoints were hit during the deployment.
     *
     * If this is not a rollback, this list will be empty.
     * @return The list of (intermediate) checkpoints hit during a deployment.
     */
    List<String> getIntermediateCheckpoints();
}
