/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class InputHint {
    private PropertyKind kind;
    private boolean required;
    private String prompt;
    private List<InputHintValue> values = new ArrayList<InputHintValue>();
    private Set<Validator<?>> validationRules = new HashSet();
    private String copyFromProperty;
    private Type referencedType;
    private String methodRef;
    private boolean dynamicLookup;

    public InputHint() {
    }

    public InputHint(PropertyKind kind, boolean required, String prompt, List<InputHintValue> values, Set<Validator<?>> validationRules, String copyFromProperty, Type referencedType, String methodRef, boolean dynamicLookup) {
        this.kind = kind;
        this.required = required;
        this.prompt = prompt;
        this.values = values;
        this.validationRules = validationRules;
        this.copyFromProperty = copyFromProperty;
        this.referencedType = referencedType;
        this.methodRef = methodRef;
        this.dynamicLookup = dynamicLookup;
    }

    public PropertyKind getKind() {
        return this.kind;
    }

    public void setKind(PropertyKind kind) {
        this.kind = kind;
    }

    public List<InputHintValue> getValues() {
        return this.values;
    }

    public void setValues(List<InputHintValue> values) {
        this.values = values;
    }

    public Set<Validator<?>> getValidationRules() {
        return this.validationRules;
    }

    public InputHint copyFrom(InputHint inputHint) {
        if (inputHint == null) {
            return this;
        }
        this.setKind(inputHint.getKind());
        this.values = inputHint.values;
        this.validationRules = inputHint.getValidationRules();
        this.setPrompt(inputHint.getPrompt());
        this.setRequired(inputHint.isRequired());
        this.setCopyFromProperty(inputHint.copyFromProperty);
        this.setReferencedType(inputHint.referencedType);
        this.setMethodRef(inputHint.methodRef);
        this.setDynamicLookup(inputHint.dynamicLookup);
        return this;
    }

    public static InputHint newInputHintFrom(InputHint inputHint) {
        return inputHint == null ? null : new InputHint().copyFrom(inputHint);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getCopyFromProperty() {
        return this.copyFromProperty;
    }

    public void setCopyFromProperty(String copyFromProperty) {
        this.copyFromProperty = copyFromProperty;
    }

    public Type getReferencedType() {
        return this.referencedType;
    }

    public void setReferencedType(Type referencedType) {
        this.referencedType = referencedType;
    }

    public String getMethodRef() {
        return this.methodRef;
    }

    public void setMethodRef(String methodRef) {
        this.methodRef = methodRef;
    }

    public boolean isDynamicLookup() {
        return this.dynamicLookup;
    }

    public void setDynamicLookup(boolean dynamicLookup) {
        this.dynamicLookup = dynamicLookup;
    }

    public static class InputHintBuilder {
        public PropertyKind kind;
        public boolean required;
        public String prompt;
        public List<InputHintValue> values = new ArrayList<InputHintValue>();
        public Set<Validator<?>> validationRules = new HashSet();
        public String copyFromProperty;
        public Type referencedType;
        public String methodRef;
        public boolean dynamicLookup;

        public InputHintBuilder construct(Consumer<InputHintBuilder> builderFunction) {
            builderFunction.accept(this);
            return this;
        }

        public InputHint constructInputHint() {
            return new InputHint(this.kind, this.required, this.prompt, this.values, this.validationRules, this.copyFromProperty, this.referencedType, this.methodRef, this.dynamicLookup);
        }
    }
}

