/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.udm.lookup;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.lookup.LookupValueProvider;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.HashMap;
import java.util.Map;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, description="A LookupValueProvider that stores values in the database.")
@PublicApiRef
public class SimpleLookupValueProvider
extends BaseConfigurationItem
implements LookupValueProvider {
    @Property(description="The lookup value entries", required=false)
    protected Map<String, String> entries = new HashMap<String, String>();
    @Property(description="The encrypted lookup value entries", required=false, password=true)
    protected Map<String, String> encryptedEntries = new HashMap<String, String>();
    @Property(description="Allow encrypted entries for non password properties.", defaultValue="false")
    protected boolean allowEncryptedForNonPassword = false;

    @Override
    public String lookup(String key, boolean password) throws Exception {
        if (this.entries.containsKey(key)) {
            return this.entries.get(key);
        }
        if (this.encryptedEntries.containsKey(key)) {
            if (!password && !this.allowEncryptedForNonPassword) {
                throw new IllegalArgumentException("Will not provide an encrypted value for a non-password field.");
            }
            return this.encryptedEntries.get(key);
        }
        return null;
    }
}

