/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = FileEncodings.Validator.class, type = "fileEncodings")
@ApplicableTo({ PropertyKind.MAP_STRING_STRING })
@Target(ElementType.FIELD)
public @interface FileEncodings {

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Map<String, String>> {

        @Override
        public void validate(Map<String, String> value, ValidationContext context) {
            if (value == null) return;

            for (Map.Entry<String, String> regexToEncoding : value.entrySet()) {
                try {
                    Pattern.compile(regexToEncoding.getKey());
                } catch (PatternSyntaxException pse) {
                    context.error("Syntax of regular expression pattern '%s' is not valid.", regexToEncoding.getKey());
                }

                try {
                    if (!Charset.isSupported(regexToEncoding.getValue())) {
                        context.error("The character set '%s' for pattern '%s' is not supported.", regexToEncoding.getValue(), regexToEncoding.getKey());
                    }
                } catch (IllegalCharsetNameException icne) {
                    context.error("The character set '%s' for pattern '%s' is not a valid character set.", regexToEncoding.getValue(), regexToEncoding.getKey());
                }
            }
        }
    }
}
