/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.plugin.api.deployment.rules;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;

public abstract class AbstractBaseRule {
    public static final String ALWAYS_RUN_CONDITION = null;

    protected String name;

    protected boolean enabled;

    protected String condition;

    protected AbstractBaseRule(String name, boolean enabled, String condition) {
        this.name = name;
        this.enabled = enabled;
        this.condition = condition;
    }

    protected boolean canFire(Map<String, Object> context) {
        return enabled;
    }

    protected abstract List<Step> fire(Map<String, Object> context);

    public String getName() {
        return name;
    }

    @Override
    public String toString() {
        return name;
    }

    public void disable() {
        enabled = false;
    }
}
